package ru.yandex.chemodan.uploader.preview;


import ru.yandex.bolts.function.Function;
import ru.yandex.misc.enums.EnumResolver;
import ru.yandex.misc.image.Dimension;

/**
 * @author akirakozov
 */
public enum PreviewImageSize {
    XXXL(1280, 1280),
    XXL(1024, 1024),
    XL(800, 800),
    L(500, 500),
    M(300, 300),
    S(150, 150),
    XS(100, 100),
    XXS(75, 75),
    XXXS(50, 50),
    ;

    private final int width;
    private final int height;

    PreviewImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public Dimension getDimension() {
        return new Dimension(width, height);
    }

    public static Function<PreviewImageSize, String> nameF() {
        return new Function<PreviewImageSize, String>() {
            public String apply(PreviewImageSize a) {
                return a.name().toLowerCase();
            }
        };
    }

    public static final EnumResolver<PreviewImageSize> R = EnumResolver.er(PreviewImageSize.class);
}
