package ru.yandex.chemodan.uploader.preview;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.commune.image.RotateAngle;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author ssytnik
 */
public class PreviewInfo extends DefaultObject {

    private final ImageFormat previewFormat;
    private final Option<Dimension> origSizeO;
    private final Dimension previewSize;
    private final Option<RotateAngle> rotateAngle;

    public PreviewInfo(
            ImageFormat previewFormat, Option<Dimension> origSizeO,
            Dimension previewSize, Option<RotateAngle> rotateAngle)
    {
        this.previewFormat = previewFormat;
        this.origSizeO = origSizeO;
        this.previewSize = previewSize;
        this.rotateAngle = rotateAngle;
    }


    public ImageFormat getPreviewFormat() {
        return previewFormat;
    }

    public Option<Dimension> getOrigSizeO() {
        return origSizeO;
    }

    public Dimension getPreviewSize() {
        return previewSize;
    }

    public Option<RotateAngle> getRotateAngel() {
        return rotateAngle;
    }

    public String toString() {
        return String.format("format:%s;origSize:%s;previewSize:%s;rotateAngle:%s",
                previewFormat, origSizeO, previewSize, rotateAngle);
    }
}
