package ru.yandex.chemodan.uploader.preview;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.image.Dimension;

/**
 * @author akirakozov
 */
public class PreviewSizeParameter {

    @JsonProperty
    private final Option<PreviewImageSize> size;
    @JsonProperty
    private final Option<Dimension> dimension;

    @JsonCreator
    public PreviewSizeParameter(
            @JsonProperty("size") Option<PreviewImageSize> size,
            @JsonProperty("dimension") Option<Dimension> dimension)
    {
        Validate.isTrue(!size.isPresent() ^ !dimension.isPresent());
        this.size = size;
        this.dimension = dimension;
    }

    public PreviewSizeParameter(PreviewImageSize size) {
        this(Option.of(size), Option.empty());
    }

    public PreviewSizeParameter(Dimension size) {
        this(Option.empty(), Option.of(size));
    }

    public boolean isDimension() {
        return dimension.isPresent();
    }

    public Dimension getDimension() {
        return dimension.get();
    }

    public PreviewImageSize getPreviewImageSize() {
        return size.get();
    }

    public Dimension asDimension() {
        if (isDimension()) {
            return getDimension();
        } else {
            return getPreviewImageSize().getDimension();
        }
    }
}
