package ru.yandex.chemodan.uploader.preview;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.ExecUtils2;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.file.File2;

/**
 * @author akirakozov
 * @author metal
 */
public class SizeExtractor {
    private final ImageMagickPathHelper pathHelper;

    public SizeExtractor(ImageMagickPathHelper helper) {
        pathHelper = helper;
    }

    public Dimension getSize(File2 image) {
        ListF<String> cmd = Cf.list(pathHelper.getIdentifyCmd(),
                "-format", "%Wx%H",
                image.getAbsolutePath()); // result

        ExecResult result = ExecUtils2.executeGrabbingOutputWithLogging(cmd);
        return Dimension.valueOf(result.getStdout().trim());
    }

}
