package ru.yandex.chemodan.uploader.preview;

import ru.yandex.misc.enums.EnumResolver;

/**
 * @author nshmakov
 */
public enum WatermarkPosition {

    NONE("None"),
    CENTER("Center"),
    SOUTH_EAST("SouthEast"),
    NORTH_WEST("NorthWest"),
    CENTER_NEW("Center"),
    NORTH("North"),
    ;

    public static final EnumResolver<WatermarkPosition> R = EnumResolver.er();

    private final String positionName;

    WatermarkPosition(String positionName) {
        this.positionName = positionName;
    }

    public String toImageMagickFormat() {
        return positionName;
    }
}
