package ru.yandex.chemodan.uploader.preview.annotations;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.preview.LogoManager;
import ru.yandex.chemodan.uploader.preview.WatermarkPosition;
import ru.yandex.chemodan.util.ExecUtils2;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;

/**
 * @author metal
 */
public class AlbumAnnotationManager {
    private static final int STARTING_NUMBER_OF_LINES = 6;

    @Autowired
    private LogoManager logoManager;

    @Autowired
    private AnnotationFileGenerator annotationFileGenerator;

    @Value("${imagemagick.convert}")
    private String convertCmd;

    @Value("${uploader.album.preview.annotation.max.width}")
    private int maxWidth;

    @Value("${uploader.album.preview.annotation.max.height}")
    private int maxHeight;

    public File2 createAlbumAnnotation(File2 tempDir,
                                       Dimension logoDimension, Annotation albumName, Annotation userName)
    {
        File2 resizedLogoFile = tempDir.child("resized-logo.png");
        File2 albumNameFile = tempDir.child("album-name.png");
        File2 userNameFile = tempDir.child("user-name.png");

        logoManager.createLogo(resizedLogoFile, logoDimension);
        Dimension albumNameDimension =
                annotationFileGenerator.createFileWithAnnotation(albumNameFile, albumName, maxWidth, -1);
        Dimension userNameDimension =
                annotationFileGenerator.createFileWithAnnotation(userNameFile, userName, maxWidth, -1);

        int maxAlbumNameHeight = getMaxAlbumNameHeight(logoDimension, userNameDimension);
        if (!checkAlbumNameHeight(albumNameDimension, maxAlbumNameHeight)) {
            reprintAlbumName(albumNameFile, albumName, maxAlbumNameHeight);
        }

        return combine(tempDir, resizedLogoFile, userNameFile, albumNameFile);
    }

    private File2 combine(File2 tempDir, File2 resizedLogoFile, File2 userNameFile, File2 albumNameFile) {
        File2 albumAnnotationFile = tempDir.child("album-annotation.png");

        ListF<String> cmd = Cf.list(convertCmd,
                "-background", "#0000",
                "-gravity", WatermarkPosition.NORTH.toImageMagickFormat(),
                resizedLogoFile.getAbsolutePath(),
                albumNameFile.getAbsolutePath(),
                "-append",
                albumAnnotationFile.getAbsolutePath()); // result

        ExecUtils2.executeWithLogging(cmd);

        cmd = Cf.list(convertCmd,
                "-background", "#0000",
                "-gravity", WatermarkPosition.NORTH.toImageMagickFormat(),
                albumAnnotationFile.getAbsolutePath(),
                userNameFile.getAbsolutePath(),
                "-append",
                albumAnnotationFile.getAbsolutePath()); // result

        ExecUtils2.executeWithLogging(cmd);

        return albumAnnotationFile;
    }

    private void reprintAlbumName(File2 albumNameFile, Annotation albumName, int maxAlbumNameHeight) {
        boolean albumNameHasProperSize = false;
        int numberOfLines = STARTING_NUMBER_OF_LINES;
        while (!albumNameHasProperSize) {
            int lineHeight = (maxAlbumNameHeight - albumName.getYOffset()) / numberOfLines;
            int newPointSize = (int) (lineHeight * AnnotationFileGenerator.LINE_HEIGHT_TO_FONT_POINTSIZE_COEFFICIENT);

            Annotation newAlbumName = new Annotation(albumName.getFont(), albumName.getFontColor(),
                    albumName.getXOffset(), albumName.getYOffset(), newPointSize,
                    albumName.getText());

            Dimension newAlbumNameDimension =
                    annotationFileGenerator.createFileWithAnnotation(albumNameFile, newAlbumName, maxWidth, -1);
            albumNameHasProperSize = checkAlbumNameHeight(newAlbumNameDimension, maxAlbumNameHeight);

            numberOfLines++;
        }
    }

    private int getMaxAlbumNameHeight(Dimension logoDimension, Dimension userNameDimension) {
        return maxHeight - logoDimension.getHeight() - userNameDimension.getHeight();
    }

    private boolean checkAlbumNameHeight(Dimension albumNameDimension, int maxAlbumNameHeight) {
        return albumNameDimension.getHeight() <= maxAlbumNameHeight;
    }
}
