package ru.yandex.chemodan.uploader.preview.annotations;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.uploader.preview.WatermarkPosition;
import ru.yandex.chemodan.util.ExecUtils2;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.exec.ShellCommandBuilder;
import ru.yandex.misc.io.file.File2;

/**
 * @author metal
 */
public class AnnotationFileGenerator {
    public static final double LINE_HEIGHT_TO_FONT_POINTSIZE_COEFFICIENT = 54 / 61.0;

    @Value("${imagemagick.convert}")
    private String convertCmd = "convert";

    private static String sizeParam(int size) {
        return size >= 0 ? String.valueOf(size) : "";
    }

    private static String sizeParams(int x, int y) {
        return sizeParam(x) + "x" + sizeParam(y);
    }

    public Dimension createFileWithAnnotation(File2 fileWithAnnotation, Annotation annotation, int maxWidth, int maxHeight) {
        ShellCommandBuilder commandBuilder = new ShellCommandBuilder();

        commandBuilder.append(convertCmd,
                "-background", "#0000",
                "-fill", annotation.getFontColor(),
                "-font", annotation.getFont());

        String text = escapeText(annotation.getText());
        if (maxHeight < 0) {
            commandBuilder.append("-pointsize", String.valueOf(annotation.getPointSize()));

            // upyachka: nasty hack for ImageMagick to avoid text cutting on the border (https://st.yandex-team.ru/CHEMODAN-24420)
            text = text + "\\n";
            int unnecessaryLineHeight = (int) (annotation.getPointSize() / LINE_HEIGHT_TO_FONT_POINTSIZE_COEFFICIENT);
            commandBuilder.append("-crop", "+0-" + unnecessaryLineHeight, "+repage");
        }

        commandBuilder.append(
                "-size", sizeParams(maxWidth, maxHeight),
                "-splice", annotation.getXOffset() + "x" + annotation.getYOffset(),
                "-gravity", WatermarkPosition.NORTH.toImageMagickFormat(),
                "caption:" + text,
                "-print", "%wx%h",
                fileWithAnnotation.getAbsolutePath()); // result

        ExecResult result = ExecUtils2.executeGrabbingOutputWithLogging(commandBuilder.commands());
        return Dimension.valueOf(result.getStdout().trim());
    }

    private String escapeText(String text) {
        return text.replaceAll("%", "%%").replaceAll("\\\\", "\\\\\\\\").replaceAll("@", "\\\\@");
    }
}
