package ru.yandex.chemodan.uploader.registry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.lang.DefaultComparable;

/**
 * @author vavinov
 */
public class ApiVersion extends DefaultComparable<ApiVersion> {
    public static final ApiVersion V_0_1 = ApiVersion.valueOf("0.1");
    public static final ApiVersion V_0_2 = ApiVersion.valueOf("0.2");

    @JsonProperty
    private final String string;

    @JsonCreator
    public ApiVersion(@JsonProperty("string") String string) {
        this.string = string;
    }

    public String toSerializedString() {
        return string;
    }

    public static ApiVersion valueOf(String s) {
        return new ApiVersion(s);
    }

    public static Function<String, ApiVersion> valueOfF() {
        return new Function<String, ApiVersion>() {
            public ApiVersion apply(String s) {
                return valueOf(s);
            }
        };
    }
}
