package ru.yandex.chemodan.uploader.registry;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.image.Dimension;

@Data
@BenderBindAllFields
public class AvatarsMeta {

    @BenderPart(name = "orig-size", strictName = true)
    private final Size origSize;

    @BenderFlatten
    private final Colors colors;

    @Data
    @BenderBindAllFields
    public static class Size {

        private final int x, y;

        public Dimension toDimension() {
            return Dimension.valueOf(x, y);
        }

    }

    @Data
    @BenderBindAllFields
    public static class Colors {

        @BenderPart(name = "MainColor", strictName = true)
        private final Option<String> mainColor;

        @BenderPart(name = "SecondColor", strictName = true)
        private final Option<String> secondColor;

        @BenderPart(name = "AverageBorderColor", strictName = true)
        private final Option<String> averageBorderColor;

        @BenderPart(name = "ColorWizButton", strictName = true)
        private final Option<String> colorWizButton;

        @BenderPart(name = "ColorWizButtonText", strictName = true)
        private final Option<String> colorWizButtonText;

        @BenderPart(name = "ColorWizButtonLowerBorder", strictName = true)
        private final Option<String> colorWizButtonLowerBorder;

        @BenderPart(name = "ColorWizButtonTextLowerBorder", strictName = true)
        private final Option<String> colorWizButtonTextLowerBorder;

        @BenderPart(name = "ColorWizText", strictName = true)
        private final Option<String> colorWizText;

        @BenderPart(name = "ColorWizTextLowerBorder", strictName = true)
        private final Option<String> colorWizTextLowerBorder;

        @BenderPart(name = "ColorWizBack", strictName = true)
        private final Option<String> colorWizBack;

        @BenderPart(name = "ColorWizBackLowerBorder", strictName = true)
        private final Option<String> colorWizBackLowerBorder;

    }

}
