package ru.yandex.chemodan.uploader.registry;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.uploader.registry.processors.RequestProcessor;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.commune.uploader.registry.RequestDirector;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.misc.spring.ApplicationContextUtils;

public class ChemodanRequestDirector implements RequestDirector {

    @Autowired
    private ApplicationContext applicationContext;

    private MapF<Class<?>, RequestProcessor<?>> processors = Cf.hashMap();

    @PostConstruct
    public void init() {
        ListF<RequestProcessor> pr = ApplicationContextUtils.beansOfType(applicationContext, RequestProcessor.class);
        for (RequestProcessor requestProcessor : pr) {
            processors.put(requestProcessor.getRecordClass(), requestProcessor);
        }
    }

    @Override
    public void act(RequestRecord record) {
        // Can't avoid this cast because of iceberg
        processors.getTs(record.getClass()).process((MpfsRequestRecord) record);
    }
}
