package ru.yandex.chemodan.uploader.registry;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.uploader.UidOrSpecial;
import ru.yandex.chemodan.uploader.av.AntivirusResult;
import ru.yandex.chemodan.uploader.mulca.MulcaUploadInfo;
import ru.yandex.chemodan.uploader.preview.PreviewSizeParameter;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.status.DigestCalculationStatus;
import ru.yandex.chemodan.uploader.registry.record.status.ExifInfo;
import ru.yandex.chemodan.uploader.registry.record.status.GenerateImageOnePreviewResult;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.commune.uploader.registry.CallbackResponse;
import ru.yandex.commune.uploader.registry.CallbackResponseOption;
import ru.yandex.commune.uploader.registry.StageResult;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.registry.UploadRequestId;
import ru.yandex.commune.uploader.util.http.ContentInfo;
import ru.yandex.commune.uploader.util.http.IncomingFile;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;

import static org.mockito.Matchers.any;
import static org.mockito.Matchers.anyBoolean;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.when;
import static ru.yandex.chemodan.uploader.test.DomainUtils.mid;
import static ru.yandex.chemodan.uploader.test.DomainUtils.uploadInfo;

/**
 * @author nshmakov
 */
public class ChemodanRequestDirectorWithMockedUploadRegistryTestUtils {

    public static <T extends MpfsRequestRecord> void prepareMockForAnyRecordUpdate(
            UploadRegistry<T> uploadRegistryMock, T record)
    {
        when(uploadRegistryMock.updateRecord(eq(record), anyBoolean())).thenReturn(record);
    }

    public static void prepareContentInfoFMock(Stages stagesMock, IncomingFile incomingFile, Option<String> filePathO,
            final Option<String> contentTypeO)
    {
        when(stagesMock.contentInfoF(incomingFile, filePathO)).thenReturn(
                () -> new ContentInfo(contentTypeO, 100500L, "md5", "sha256"));

    }

    public static void prepareCommitUploadFileProgressFMock(Stages stagesMock, MpfsRequestRecord record) {
        when(stagesMock.commitUploadFileProgressF(eq(record), any(String.class))).thenReturn(
                () -> StageResult.success(
                        new CallbackResponseOption(
                                Option.of(
                                        new CallbackResponse(200, "", "", Cf.map(), Option.empty())))));
    }

    public static void prepareUploadFileToMulcaFMock(Stages stagesMock, IncomingFile incomingFile, UidOrSpecial uid) {
        when(stagesMock.uploadFileToMulcaF(incomingFile.getRawFile(), uid)).thenReturn(mulcaUploadInfoStubF(1));
    }

    public static void prepareCalculateDigestFMock(Stages stagesMock, UploadRequestId requestId, IncomingFile incomingFile) {
        when(stagesMock
                .calculateDigestF(requestId, incomingFile.getRawFile()))
                .thenReturn(digestCalculationStatusStubF(incomingFile.getRawFile()));
    }

    public static void prepareUploadDigestToMulcaFMock(Stages stagesMock, IncomingFile incomingFile, UidOrSpecial uid) {
        when(stagesMock.uploadDigestToMulcaF(incomingFile.getRawFile(), uid)).thenReturn(mulcaUploadInfoStubF(2));
    }

    public static void preparePreviewUploadFileToMulcaFMock(Stages stagesMock, File2 previewFile, UidOrSpecial uid) {
        when(stagesMock.uploadFileToMulcaF(previewFile, uid)).thenReturn(mulcaUploadInfoStubF(3));
    }

    public static void prepareExtractExifInfoFMock(Stages stagesMock, IncomingFile incomingFile,
            MpfsRequestRecord record, String contentType)
    {
        when(stagesMock.extractExifInfoF(record.meta.id, incomingFile.getRawFile(), Option.empty(), contentType, any()))
                .thenReturn(() -> StageResult.success(new ExifInfo(
                                Option.empty(),
                                Option.empty())));
    }

    public static void prepareGenerateOnePreviewForImageFMock(Stages stagesMock, IncomingFile incomingFile,
            MpfsRequestRecord record, final File2 previewFile, Option<String> contentTypeO)
    {
        when(stagesMock.generateOnePreviewForImageF(eq(record.meta.id), eq(incomingFile.getRawFile()), eq(contentTypeO),
                any(PreviewSizeParameter.class), eq(true), eq(false), any(Option.class))).thenReturn(
                    () ->  StageResult.success(new GenerateImageOnePreviewResult(previewFile, ImageFormat.JPEG,
                            Option.empty(), Dimension.valueOf(10, 10), Option.empty())));
    }

    public static void prepareCheckWithAntivirusFMock(Stages stagesMock, IncomingFile incomingFile) {
        when(stagesMock.checkWithAntivirusF(any(Option.class), eq(incomingFile.getRawFile()))).thenReturn(
                () -> StageResult.success(AntivirusResult.HEALTHY));
    }

    private static Function0<MulcaUploadInfo> mulcaUploadInfoStubF(final int id) {
        return () -> uploadInfo(mid(id));
    }

    private static Function0<DigestCalculationStatus> digestCalculationStatusStubF(File2 digest) {
        return () -> new DigestCalculationStatus(Option.of(digest), Option.of(1L));
    }
}
