package ru.yandex.chemodan.uploader.registry.processors;

import java.net.URI;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mulca.MulcaUploadManager;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.chemodan.uploader.services.ServiceFileId;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.chemodan.util.exception.PermanentFailureException;
import ru.yandex.commune.uploader.local.file.LocalFileManager;
import ru.yandex.commune.uploader.registry.StopDueToPrematureSuccess;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentInfo;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.commune.uploader.util.http.IncomingFile;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.http.UrlUtils;

/**
 * @author metal
 */
public class ConvertToMsOoxmlFormatProcessor extends BaseUploadProcessor<MpfsRequestRecord.ConvertToMsOoxmlFormat> {

    ConvertToMsOoxmlFormatProcessor(RequestStatesHandler statesListener, Stages stages,
            DocviewerClient docviewerClient, MulcaUploadManager mulcaUploadManager, LocalFileManager localFileManager,
            BleedingEdge experimentalBleedingEdge)
    {
        super(MpfsRequestRecord.ConvertToMsOoxmlFormat.class, statesListener, stages, docviewerClient,
                mulcaUploadManager, localFileManager, experimentalBleedingEdge);
    }

    @Override
    protected void processTs(Record<MpfsRequestRecord.ConvertToMsOoxmlFormat> record) {
        MpfsRequestStatus.ConvertToMsOoxmlFormat status = record.get().getStatus();
        MpfsRequest.ConvertToMsOoxmlFormat request = record.get().getRequest();

        statesHandler.processSuccess(record, status.convertedFile,
                stages.convertFileToMsOoxmlFormatF(record.get().meta.id,
                        getProperIncomingFileUrl(request),
                        record.get().getRequest().chemodanFile.getUidOrSpecial(),
                        request.archivePath,
                        request.contentType)
        );

        for (IncomingFile convertedFile : status.convertedFile.get().getResultO()) {
            processUpload(record, convertedFile);
        }
    }

    private URI getProperIncomingFileUrl(MpfsRequest.ConvertToMsOoxmlFormat request) {
        try {
            return request.sourceService.isExternal()
                    ? new URI(request.serviceFileInfo.get().serviceFileUrl)
                    : getUriByServiceFileId(request.sourceService, request.serviceFileId.get());
        } catch (Exception e) {
            throw new PermanentFailureException("Can't obtain proper file url to convert it to MS OOXML format.", e);
        }
    }

    private URI getUriByServiceFileId(ChemodanService service, ServiceFileId serviceFileId) {
        if (ChemodanService.BROWSER == service) {
            return UrlUtils.uri("ya-browser://" + serviceFileId.n);
        } else if (ChemodanService.MAIL2 == service) {
            return UrlUtils.uri("ya-mail://" + serviceFileId.n);
        } else {
            // TODO: list of supported service for mulcaId
            return MulcaId.fromSerializedString(serviceFileId.n).asMulcaUri();
        }
    }

    private void processUpload(
            final Record<MpfsRequestRecord.ConvertToMsOoxmlFormat> record, final IncomingFile incomingFile)
    {
        MpfsRequestStatus.ConvertToMsOoxmlFormat status = record.get().getStatus();
        MpfsRequest.ConvertToMsOoxmlFormat request = record.get().getRequest();

        try {
            statesHandler.processSuccess(record, status.payloadInfo,
                    stages.contentInfoF(incomingFile, Option.of(request.chemodanFile.getPath())));

            for (ContentInfo payloadInfo : status.payloadInfo.get().getResultO()) {
                Content content = ContentUtils.multipartOrRaw(incomingFile);
                postProcessFile(record, ContentUtils.withType(payloadInfo.getContentType(), content),
                        request.chemodanFile.getUidOrSpecial(), status.postProcess);
            }
        } catch (StopDueToPrematureSuccess ex) {
            // premature success case handled by finalizeUpload
        } finally {
            processPrematureSuccess(record, status.postProcess);
        }
    }
}
