package ru.yandex.chemodan.uploader.registry.processors;

import org.apache.commons.io.FileUtils;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.ChemodanService;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.ExportPhotoStatus;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.chemodan.uploader.registry.record.status.UploadedMulcaFile;
import ru.yandex.chemodan.uploader.social.SocialProxyStages;
import ru.yandex.chemodan.uploader.social.response.SocialUploadInfoResponse;
import ru.yandex.commune.uploader.registry.RequestDirectorUtils;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.thread.ThreadUtils;

import static ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.ExportPhotos;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class ExportPhotosProcessor extends RequestProcessor<ExportPhotos> {

    private static final Logger logger = LoggerFactory.getLogger(ExportPhotosProcessor.class);
    private final SocialProxyStages socialProxyStages;
    private final boolean exportVkUseSleep;
    private final Duration exportVkSleepDuration;

    public ExportPhotosProcessor(
            RequestStatesHandler listener, Stages stages,
            SocialProxyStages socialProxyStages,
            boolean exportVkUseSleep, Duration exportVkSleepDuration)
    {
        super(ExportPhotos.class, listener, stages);
        this.socialProxyStages = socialProxyStages;
        this.exportVkUseSleep = exportVkUseSleep;
        this.exportVkSleepDuration = exportVkSleepDuration;
    }

    @Override
    protected void processTs(Record<ExportPhotos> record) {
        MpfsRequestStatus.ExportPhotos status = record.get().getStatus();
        ListF<MulcaId> previewMulcaIds = record.get().getRequest().photoPreviewMulcaIds;

        Validate.sameSize(previewMulcaIds, status.multiplePhotoExport.queue);
        for (int i = 0; i < previewMulcaIds.size(); i++) {
            exportPhoto(record, previewMulcaIds.get(i), status.multiplePhotoExport.queue.get(i));
        }
    }

    private void exportPhoto(final Record<MpfsRequestRecord.ExportPhotos> record,
                             MulcaId mulcaId, ExportPhotoStatus status)
    {
        boolean wasMetaRequst = false;
        MpfsRequest.ExportPhotos req = record.get().getRequest();
        statesHandler.processSuccess(record, status.previewFile, stages.downloadFromMulcaF(record.get().meta.id, mulcaId));

        if (status.previewFile.get().isFinished()) {
            if (status.previewFile.get().getResultO().isPresent()) {
                statesHandler.processSuccess(record, status.uploadInfo,
                        socialProxyStages.getPhotoUploadInfo(req.profileId, req.albumId));
                wasMetaRequst = true;
            } else {
                RequestDirectorUtils.skip(record, status.uploadInfo);
            }
        }

        if (status.uploadInfo.get().isFinished()) {
            if (status.uploadInfo.get().getResultO().isPresent()) {
                SocialUploadInfoResponse.SocialUploadInfo uploadInfo = status.uploadInfo.get().getResultO().get();
                File2 localFile = status.previewFile.get().getResultO().get().getLocalFile();
                statesHandler.processSuccess(record, status.uploadToSocialNet,
                        socialProxyStages.uploadPhotoToScialNet(uploadInfo, localFile));
            } else {
                RequestDirectorUtils.skip(record, status.uploadToSocialNet);
            }
        }

        if (status.uploadToSocialNet.get().isFinished()) {
            if (status.uploadToSocialNet.get().getResultO().isPresent()) {
                String uploadResponse = status.uploadToSocialNet.get().getResultO().get();
                statesHandler.processSuccess(record, status.commitUploadMeta,
                        socialProxyStages.commitPhotoUpload(req.profileId, req.albumId, uploadResponse));
                wasMetaRequst = true;
            } else {
                RequestDirectorUtils.skip(record, status.commitUploadMeta);
            }
        }

        if (status.commitUploadMeta.get().isFinished()) {
            Option<UploadedMulcaFile> previewFile = status.previewFile.get().getResultO();
            if (previewFile.isPresent()) {
                File2 localFile = previewFile.get().getLocalFile();
                logger.debug("Try to remove local file: " + localFile.getAbsolutePath());
                FileUtils.deleteQuietly(localFile.getFile());
            }
        }

        if (wasMetaRequst && exportVkUseSleep && req.targetService == ChemodanService.VKONTAKTE) {
            ThreadUtils.sleep(exportVkSleepDuration);
        }
    }
}
