package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.mulca.MulcaUploadManager;
import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ExtractedFile;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.ExtractArchive;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.DefaultUploadStatus;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.chemodan.uploader.registry.record.status.PostProcessStatus;
import ru.yandex.chemodan.uploader.services.ServiceIncomingFile;
import ru.yandex.chemodan.uploader.social.ExternalResourceSemaphores;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.uploader.local.file.LocalFileManager;
import ru.yandex.commune.uploader.registry.CachedFieldsInfo;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.StopDueToPrematureSuccess;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentInfo;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.commune.uploader.util.http.IncomingFile;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class ExtractArchiveProcessor extends BaseUploadProcessor<ExtractArchive> {

    private ExternalResourceSemaphores externalResourceSemaphores;

    ExtractArchiveProcessor(RequestStatesHandler statesListener, Stages stages, DocviewerClient docviewerClient,
            MulcaUploadManager mulcaUploadManager, ExternalResourceSemaphores externalResourceSemaphores,
            LocalFileManager localFileManager, BleedingEdge experimentalBleedingEdge) {
        super(ExtractArchive.class, statesListener, stages, docviewerClient, mulcaUploadManager, localFileManager, experimentalBleedingEdge);
        this.externalResourceSemaphores = externalResourceSemaphores;
    }

    @Override
    protected void processTs(Record<ExtractArchive> record) {
        MpfsRequestStatus.ExtractArchive status = record.get().getStatus();
        MpfsRequest.ExtractArchive request = record.get().getRequest();

        Function0<ServiceIncomingFile> op = externalResourceSemaphores.executeWithSemaphoreF(
                request.sourceService,
                stages.downloadFileFromServiceF(
                        record.get().meta.id,
                        request.sourceService,
                        request.serviceFileInfo,
                        request.serviceFileId)
        );

        statesHandler.processSuccess(record, status.downloadedFileFromService2, op);

        for (ServiceIncomingFile serviceIncomingFile : status.downloadedFileFromService2.get().getResultO()) {
            statesHandler.processSuccess(record, status.extractedFiles,
                    stages.extractArchiveF(record.get().meta.id, serviceIncomingFile.getIncomingFile().getRawFile(),
                            record.get().getRequest().fileToExtract, record.get().getRequest().maxFileSize));
        }

        Option<ListF<ExtractedFile>> extractedFilesO = status.extractedFiles.get().getResultO();
        if (extractedFilesO.isPresent() && status.multipleUpload.queue.isEmpty()) {
            ChemodanFile chemodanFile = record.get().getRequest().chemodanFile;
            status.multipleUpload.fill(chemodanFile.getUidOrSpecial(),
                    chemodanFile.getPath(), extractedFilesO.get());
            status.addDynamicFields(new CachedFieldsInfo(status.multipleUpload));
        }
        processMultipleUploads(record, status.multipleUpload.queue);
    }

    private void processMultipleUploads(Record<ExtractArchive> record,
                                        ListF<DefaultUploadStatus> queue)
    {
        for (DefaultUploadStatus dus : queue) {
            try {
                dus.isActive = true;
                processUpload(record, dus.userFile, dus.payloadInfo, dus.postProcess, dus.chemodanFile);
                dus.isActive = false;
            } finally {
                if (dus.postProcess.isFinishedWithoutFinalStages()) {
                    statesHandler.rollbackOrNot(dus.postProcess, record.get().getRequest().yandexCloudRequestId);
                }
            }
        }
    }

    private void processUpload(
            final Record<ExtractArchive> record,
            final IncomingFile incomingFile, MutableState<ContentInfo> payloadInfoStatus,
            PostProcessStatus postProcess, ChemodanFile chemodanFile)
    {
        try {
            statesHandler.processSuccess(record, payloadInfoStatus,
                    stages.contentInfoF(incomingFile, Option.of(chemodanFile.getPath())));

            for (ContentInfo payloadInfo : payloadInfoStatus.get().getResultO()) {
                Content content = ContentUtils.multipartOrRaw(incomingFile);
                postProcessFile(record, ContentUtils.withType(payloadInfo.getContentType(), content),
                        chemodanFile.getUidOrSpecial(), postProcess);
            }
        } catch (StopDueToPrematureSuccess ex) {
            // premature success case handled by finalizeUpload
        } finally {
            processPrematureSuccess(record, postProcess);
        }
    }
}
