package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.mulca.MulcaUploadManager;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.chemodan.uploader.services.ServiceIncomingFile;
import ru.yandex.chemodan.uploader.social.ExternalResourceSemaphores;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.uploader.local.file.LocalFileManager;
import ru.yandex.commune.uploader.registry.StopDueToPrematureSuccess;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentInfo;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.commune.uploader.util.http.IncomingFile;

/**
 * @author metal
 */
public class ExtractFileFromArchiveProcessor extends BaseUploadProcessor<MpfsRequestRecord.ExtractFileFromArchive> {

    private ExternalResourceSemaphores externalResourceSemaphores;

    ExtractFileFromArchiveProcessor(RequestStatesHandler statesListener, Stages stages,
            DocviewerClient docviewerClient, MulcaUploadManager mulcaUploadManager,
            ExternalResourceSemaphores externalResourceSemaphores, LocalFileManager localFileManager,
            BleedingEdge experimentalBleedingEdge)
    {
        super(MpfsRequestRecord.ExtractFileFromArchive.class, statesListener, stages, docviewerClient,
                mulcaUploadManager, localFileManager, experimentalBleedingEdge);
        this.externalResourceSemaphores = externalResourceSemaphores;
    }

    @Override
    protected void processTs(Record<MpfsRequestRecord.ExtractFileFromArchive> record) {
        MpfsRequestStatus.ExtractFileFromArchive status = record.get().getStatus();
        MpfsRequest.ExtractFileFromArchive request = record.get().getRequest();

        Function0<ServiceIncomingFile> op = externalResourceSemaphores.executeWithSemaphoreF(
                request.sourceService,
                stages.downloadFileFromServiceF(
                        record.get().meta.id,
                        request.sourceService,
                        request.serviceFileInfo,
                        request.serviceFileId)
        );

        statesHandler.processSuccess(record, status.downloadedFileFromService2, op);

        for (ServiceIncomingFile serviceIncomingFile : status.downloadedFileFromService2.get().getResultO()) {
            statesHandler.processSuccess(record, status.extractedFile,
                    stages.extractFileFromArchiveF(record.get().meta.id,
                            serviceIncomingFile.getIncomingFile().getRawFile(),
                            request.fileToExtract,
                            request.maxFileSize)
            );
        }

        for (IncomingFile extractedFile : status.extractedFile.get().getResultO()) {
            processUpload(record, extractedFile);
        }
    }

    private void processUpload(
            final Record<MpfsRequestRecord.ExtractFileFromArchive> record, final IncomingFile incomingFile)
    {
        MpfsRequestStatus.ExtractFileFromArchive status = record.get().getStatus();
        MpfsRequest.ExtractFileFromArchive request = record.get().getRequest();

        try {
            statesHandler.processSuccess(record, status.payloadInfo,
                    stages.contentInfoF(incomingFile, Option.of(request.chemodanFile.getPath())));

            for (ContentInfo payloadInfo : status.payloadInfo.get().getResultO()) {
                Content content = ContentUtils.multipartOrRaw(incomingFile);
                postProcessFile(record, ContentUtils.withType(payloadInfo.getContentType(), content),
                        request.chemodanFile.getUidOrSpecial(), status.postProcess);
            }
        } catch (StopDueToPrematureSuccess ex) {
            // premature success case handled by finalizeUpload
        } finally {
            processPrematureSuccess(record, status.postProcess);
        }
    }
}
