package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.GeneratePreview;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.chemodan.uploader.registry.record.status.UploadedMulcaFile;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class GeneratePreviewProcessor extends RequestProcessor<GeneratePreview> {

    public GeneratePreviewProcessor(RequestStatesHandler statesListener, Stages stages) {
        super(GeneratePreview.class, statesListener, stages);
    }

    @Override
    protected void processTs(Record<GeneratePreview> record) {
        MpfsRequestStatus.GeneratePreview status = record.get().getStatus();

        statesHandler.processSuccess(record, status.originalFile,
                stages.downloadFromMulcaF(record.get().meta.id, record.get().getRequest().originalFile));

        for (UploadedMulcaFile originalFile : status.originalFile.get().getResultO()) {
            statesHandler.process(record, status.generatePreview,
                    stages.generateOnePreviewForImageF(
                            record.get().meta.id,
                            originalFile.getLocalFile(),
                            record.get().getRequest().size,
                            true,
                            record.get().getRequest().crop, record.get().getRequest().quality));
        }
    }
}
