package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.ListArchive;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.UploadedMulcaFile;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class ListArchiveProcessor extends RequestProcessor<ListArchive> {
    public ListArchiveProcessor(RequestStatesHandler statesListener, Stages stages) {
        super(ListArchive.class, statesListener, stages);
    }

    @Override
    protected void processTs(Record<ListArchive> record) {
        statesHandler.processSuccess(record, record.get().getStatus().originalFile,
                stages.downloadFromMulcaF(record.get().meta.id, record.get().getRequest().originalFile));

        for (UploadedMulcaFile originalFile : record.get().getStatus().originalFile.get().getResultO()) {
            statesHandler.processSuccess(record, record.get().getStatus().listing,
                    stages.listArchiveF(originalFile.getLocalFile()));
        }
    }
}
