package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.MarkMulcaIdsForRemove;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.MarkMulcaIdForRemoveStatus;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.lang.Validate;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class MarkMidForRemoveProcessor extends RequestProcessor<MarkMulcaIdsForRemove> {

    public MarkMidForRemoveProcessor(RequestStatesHandler statesListener, Stages stages) {
        super(MarkMulcaIdsForRemove.class, statesListener, stages);
    }

    @Override
    protected void processTs(Record<MarkMulcaIdsForRemove> record) {
        ListF<MulcaId> mulcaIds = record.get().getRequest().mulcaIds;
        ListF<MarkMulcaIdForRemoveStatus> queue =
                record.get().getStatus().multipleMarkMulcaIdForRemoveStatus.queue;
        Validate.sameSize(mulcaIds, queue);

        for (int i = 0; i < mulcaIds.size(); i++) {
            statesHandler.processSuccess(
                    record,
                    queue.get(i).markForRemove, stages.markMulcaIdToRemoveF(mulcaIds.get(i)));
        }
    }
}
