package ru.yandex.chemodan.uploader.registry.processors;


import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mulca.MulcaUploadManager;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.UploadedMulcaFile;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.uploader.local.file.LocalFileManager;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentInfo;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.commune.uploader.util.http.IncomingFile;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.Check;

import static ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.PatchAtDefault;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class PatchAtDefaultProcessor extends BaseUploadProcessor<PatchAtDefault> {

    PatchAtDefaultProcessor(RequestStatesHandler listener, Stages stages, DocviewerClient docviewerClient,
            MulcaUploadManager mulcaUploadManager, LocalFileManager localFileManager,
            BleedingEdge experimentalBleedingEdge) {
        super(PatchAtDefault.class, listener, stages, docviewerClient, mulcaUploadManager, localFileManager, experimentalBleedingEdge);
    }

    @Override
    protected void processTs(Record<PatchAtDefault> record) {
        for (final IncomingFile incomingPatch : record.get().getStatus().incomingPatch.get().getResultO()) {
            Check.isTrue(record.get().getStatus().expectedPatchedMd5.get().isSuccess());

            statesHandler.processSuccess(record, record.get().getStatus().originalFile2,
                    stages.downloadFromMulcaF(record.get().meta.id, record.get().getRequest().originalFile));

            for (UploadedMulcaFile originalFile : record.get().getStatus().originalFile2.get().getResultO()) {
                statesHandler.processSuccess(record, record.get().getStatus().patchedFile,
                        stages.patchLocalFileF(record.get().meta.id, originalFile.getLocalFile(),
                                record.get().getRequest().originalMd5,
                                // FIXME original file content-type should be passed by MPFS
                                ContentUtils.multipartOrRaw(incomingPatch).getInputStreamSource(),
                                record.get().getStatus().expectedPatchedMd5.get().getResultO().get(),
                                record.get().getRequest().maxFileSize));
            }

            for (File2 patchedFile : record.get().getStatus().patchedFile.get().getResultO()) {
                Content patchedContent = ContentUtils.ofUnknownType(patchedFile);

                statesHandler.processSuccess(record, record.get().getStatus().patchedPayloadInfo,
                        stages.contentInfoF(patchedContent, patchedFile,
                                Option.of(record.get().getRequest().chemodanFile.getPath())));

                for (ContentInfo info : record.get().getStatus().patchedPayloadInfo.get().getResultO()) {
                    patchedContent = ContentUtils.withType(info.getContentType(), patchedContent);
                }

                postProcessFile(record, patchedContent,
                        record.get().getRequest().chemodanFile.getUidOrSpecial(),
                        record.get().getStatus().postProcess);
            }
        }
    }
}
