package ru.yandex.chemodan.uploader.registry.processors;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.mulca.MulcaUploadManager;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.mulca.SimultaneousMulcaUploadManager;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.ZipFolderStages;
import ru.yandex.chemodan.uploader.services.ServiceApis;
import ru.yandex.chemodan.uploader.social.ExternalResourceSemaphores;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.uploader.local.file.LocalFileManager;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
@Configuration
public class ProcessorsContextConfiguration {

    @Value("${uploader.export.vk.use.sleep:-true}")
    private boolean exportVkUseSleep;
    @Value("${uploader.export.vk.sleep.duration:-300ms}")
    private Duration exportVkSleepDuration;

    @Bean
    ExtractArchiveProcessor extractArchiveProcessor(Stages stages, MulcaUploadManager mulcaUploadManager,
            RequestStatesHandler requestStatesHandler, ExternalResourceSemaphores externalResourceSemaphores,
            DocviewerClient docviewerClient, LocalFileManager localFileManager,
            @Qualifier("experimental") BleedingEdge experimentalBleedingEdge) {
        return new ExtractArchiveProcessor(requestStatesHandler, stages, docviewerClient, mulcaUploadManager,
                externalResourceSemaphores, localFileManager, experimentalBleedingEdge);
    }

    @Bean
    ExtractFileFromArchiveProcessor extractFileFromArchiveProcessor(Stages stages,
            MulcaUploadManager mulcaUploadManager, RequestStatesHandler requestStatesHandler,
            ExternalResourceSemaphores externalResourceSemaphores, DocviewerClient docviewerClient,
            LocalFileManager localFileManager,
            @Qualifier("experimental") BleedingEdge experimentalBleedingEdge) {
        return new ExtractFileFromArchiveProcessor(requestStatesHandler, stages, docviewerClient, mulcaUploadManager,
                externalResourceSemaphores, localFileManager, experimentalBleedingEdge);
    }

    @Bean
    ConvertToMsOoxmlFormatProcessor convertToMsOoxmlFormatProcessor(Stages stages,
            MulcaUploadManager mulcaUploadManager, RequestStatesHandler requestStatesHandler,
            DocviewerClient docviewerClient, LocalFileManager localFileManager,
            @Qualifier("experimental") BleedingEdge experimentalBleedingEdge) {
        return new ConvertToMsOoxmlFormatProcessor(requestStatesHandler, stages, docviewerClient, mulcaUploadManager,
                localFileManager, experimentalBleedingEdge);
    }

    @Bean
    GeneratePreviewProcessor generatePreviewProcessor(Stages stages, RequestStatesHandler requestStatesHandler) {
        return new GeneratePreviewProcessor(requestStatesHandler, stages);
    }

    @Bean
    ListArchiveProcessor listArchiveProcessor(Stages stages, RequestStatesHandler requestStatesHandler) {
        return new ListArchiveProcessor(requestStatesHandler, stages);
    }

    @Bean
    MarkMidForRemoveProcessor markMidForRemoveProcessor(Stages stages, RequestStatesHandler requestStatesHandler) {
        return new MarkMidForRemoveProcessor(requestStatesHandler, stages);
    }

    @Bean
    PatchAtDefaultProcessor patchAtDefaultProcessor(Stages stages, MulcaUploadManager mulcaUploadManager,
            RequestStatesHandler requestStatesHandler, DocviewerClient docviewerClient,
            LocalFileManager localFileManager,
            @Qualifier("experimental") BleedingEdge experimentalBleedingEdge) {
        return new PatchAtDefaultProcessor(requestStatesHandler, stages, docviewerClient, mulcaUploadManager,
                localFileManager, experimentalBleedingEdge);
    }

    @Bean
    PublishToServiceProcessor publishToServiceProcessor(Stages stages, RequestStatesHandler requestStatesHandler, ServiceApis serviceApis) {
        return new PublishToServiceProcessor(requestStatesHandler, stages, serviceApis);
    }

    @Bean
    RegeneratePreviewProcessor regeneratePreviewProcessor(Stages stages, MulcaUploadManager mulcaUploadManager,
            RequestStatesHandler requestStatesHandler, DocviewerClient docviewerClient,
            LocalFileManager localFileManager,
            @Qualifier("experimental") BleedingEdge experimentalBleedingEdge) {
        return new RegeneratePreviewProcessor(requestStatesHandler, stages, docviewerClient, mulcaUploadManager,
                localFileManager, experimentalBleedingEdge);
    }

    @Bean
    UploadFromServiceProcessor uploadFromServiceProcessor(Stages stages, MulcaUploadManager mulcaUploadManager,
            RequestStatesHandler requestStatesHandler, ExternalResourceSemaphores externalResourceSemaphores,
            DocviewerClient docviewerClient, LocalFileManager localFileManager,
            @Qualifier("experimental") BleedingEdge experimentalBleedingEdge) {
        return new UploadFromServiceProcessor(requestStatesHandler, stages, docviewerClient,
                mulcaUploadManager, externalResourceSemaphores, localFileManager, experimentalBleedingEdge);
    }

    @Bean
    UploadToDefaultProcessor uploadToDefaultProcessor(Stages stages, MulcaUploadManager mulcaUploadManager,
            RequestStatesHandler requestStatesHandler, DocviewerClient docviewerClient,
            LocalFileManager localFileManager,
            @Qualifier("experimental") BleedingEdge experimentalBleedingEdge,
            SimultaneousMulcaUploadManager simultaneousMulcaUploadManager) {
        return new UploadToDefaultProcessor(requestStatesHandler, stages, docviewerClient, mulcaUploadManager,
                localFileManager, experimentalBleedingEdge, simultaneousMulcaUploadManager);
    }

    @Bean
    UploadToServiceProcessor uploadToServiceProcessor(Stages stages, RequestStatesHandler requestStatesHandler, ServiceApis serviceApis) {
        return new UploadToServiceProcessor(requestStatesHandler, stages, serviceApis);
    }

    @Bean
    ZipFolderProcessor zipFolderProcessor(Stages stages, RequestStatesHandler requestStatesHandler, ZipFolderStages zipFolderStages) {
        return new ZipFolderProcessor(requestStatesHandler, zipFolderStages, stages);
    }
}
