package ru.yandex.chemodan.uploader.registry.processors;


import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.PublishToService;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.UploadedMulcaFile;
import ru.yandex.chemodan.uploader.services.ServiceApis;
import ru.yandex.commune.uploader.util.http.ContentUtils;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class PublishToServiceProcessor extends RequestProcessor<PublishToService> {

    private final ServiceApis serviceApis;

    public PublishToServiceProcessor(RequestStatesHandler statesListener, Stages stages, ServiceApis serviceApis) {
        super(PublishToService.class, statesListener, stages);
        this.serviceApis = serviceApis;
    }

    @Override
    protected void processTs(Record<PublishToService> record) {
        statesHandler.processSuccess(record, record.get().getStatus().originalFile2,
                stages.downloadFromMulcaF(record.get().meta.id, record.get().getRequest().diskFile));

        for (final UploadedMulcaFile diskFile : record.get().getStatus().originalFile2.get().getResultO()) {
            statesHandler.processSuccess(record, record.get().getStatus().publishResult,
                    () -> serviceApis.publish(record.get().getRequest().chemodanFile,
                            ContentUtils.ofUnknownType(diskFile.getLocalFile()),
                            record.get().getRequest().targetService));
        }
    }
}
