package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.mulca.MulcaUploadManager;
import ru.yandex.chemodan.uploader.UidOrSpecial;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.preview.PreviewImageManager;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.RegeneratePreview;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.chemodan.uploader.registry.record.status.PreviewImageStatus;
import ru.yandex.chemodan.uploader.registry.record.status.UploadedMulcaFile;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.uploader.local.file.LocalFileManager;
import ru.yandex.commune.uploader.registry.RequestDirectorUtils;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class RegeneratePreviewProcessor extends BaseUploadProcessor<RegeneratePreview> {

    private final DynamicProperty<Boolean> avatarsEnabledForVideos =
            new DynamicProperty<>("uploader-enable-avatars-for-regenerate-video-preview", false);
    private final DynamicProperty<Boolean> avatarsEnabledForDocs =
            new DynamicProperty<>("uploader-enable-avatars-for-regenerate-doc-preview", false);

    RegeneratePreviewProcessor(RequestStatesHandler statesListener, Stages stages,
            DocviewerClient docviewerClient, MulcaUploadManager mulcaUploadManager, LocalFileManager localFileManager,
            BleedingEdge experimentalBleedingEdge)
    {
        super(RegeneratePreview.class, statesListener, stages, docviewerClient, mulcaUploadManager, localFileManager,
                experimentalBleedingEdge);
    }

    @Override
    protected void processTs(Record<RegeneratePreview> record) {
        MulcaId mulcaId = record.get().getRequest().originalFile;
        String mimeType = record.get().getRequest().mimeType;
        Option<String> filename = record.get().getRequest().fileName;
        Option<Long> sizeO = record.get().getRequest().size.map(DataSize::toBytes);
        UidOrSpecial.Special specialUid = UidOrSpecial.special("preview");

        MpfsRequestStatus.RegeneratePreview rp = record.get().getStatus();

        mimeType = docviewerClient.correctMimeTypeByFileNameIfUnknown(mimeType, filename);
        generatePreviewIfDocument(record, Option.of(mimeType), sizeO, mulcaId, specialUid, rp.previewDocumentStatus, avatarsEnabledForDocs.get());

        extractVideoInfoIfVideo(record, mimeType, mulcaId, rp.videoInfo);
        if (rp.videoInfo.get().isFinished()) {
            generatePreviewIfVideo(record, Option.of(mimeType),
                    Either.right(mulcaId),
                    specialUid, rp.previewVideoStatus, rp.videoInfo.get().getResultO(), avatarsEnabledForVideos.get());
        }

        if (PreviewImageManager.isSupportedMimeType(mimeType) && !sizeO.isMatch(s -> s > maxSizeForImagePreview.get())) {
            statesHandler.processSuccess(record, rp.originalFile,
                    stages.downloadFromMulcaF(record.get().meta.id, mulcaId));

            for (UploadedMulcaFile originalFile : rp.originalFile.get().getResultO()) {
                Content content = ContentUtils.asContent(originalFile.getLocalFile(), mimeType);
                generatePreviewIfImage(record, content, mulcaId, specialUid, rp.previewImageStatus);
            }
        } else {
            PreviewImageStatus pis = rp.previewImageStatus;
            RequestDirectorUtils.skip(record, pis.generateOnePreview);
            RequestDirectorUtils.skip(record, pis.previewMulcaUploadInfo);
            RequestDirectorUtils.skip(record, pis.colorData);
            RequestDirectorUtils.skip(record, rp.originalFile);
        }
    }
}
