package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.Record;

/**
 * Workflow for MPFS requests.
 * @param <T> the type of mpfs request processed by this processor
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public abstract class RequestProcessor<T extends MpfsRequestRecord> {

    protected final RequestStatesHandler statesHandler;
    protected final Stages stages;

    private final Class<T> requestClass;

    public RequestProcessor(
            Class<T> requestClass, RequestStatesHandler requstStatesHandler,
            Stages stages)
    {
        this.requestClass = requestClass;
        this.statesHandler = requstStatesHandler;
        this.stages = stages;
    }

    public final void process(MpfsRequestRecord record) {
        statesHandler.withHandleIncomingFileAndFinalize((T) record, this::processTs);
    }

    public Class<T> getRecordClass() {
        return requestClass;
    }

    protected abstract void processTs(Record<T> record);
}
