package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.mulca.MulcaUploadManager;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequest;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.services.ServiceIncomingImage;
import ru.yandex.chemodan.uploader.social.ExternalResourceSemaphores;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.commune.uploader.local.file.LocalFileManager;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentInfo;
import ru.yandex.commune.uploader.util.http.ContentUtils;

import static ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.UploadFromService;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class UploadFromServiceProcessor extends BaseUploadProcessor<UploadFromService> {

    private final ExternalResourceSemaphores externalResourceSemaphores;

    UploadFromServiceProcessor(RequestStatesHandler listener, Stages stages, DocviewerClient docviewerClient,
            MulcaUploadManager mulcaUploadManager, ExternalResourceSemaphores externalResourceSemaphores,
            LocalFileManager localFileManager, BleedingEdge experimentalBleedingEdge)
    {
        super(UploadFromService.class, listener, stages, docviewerClient, mulcaUploadManager, localFileManager, experimentalBleedingEdge);
        this.externalResourceSemaphores = externalResourceSemaphores;
    }

    @Override
    protected void processTs(Record<UploadFromService> record) {
        MpfsRequest.UploadFromService request = record.get().getRequest();
        Function0<ServiceIncomingImage> op = externalResourceSemaphores.executeWithSemaphoreF(
                request.sourceService,
                stages.downloadFileFromServiceF(
                        record.get().meta.id,
                        request.sourceService,
                        request.disableRetries,
                        request.disableRedirects,
                        request.serviceImageInfo,
                        request.serviceFileId,
                        request.aviaryOriginalMulcaId,
                        request.maxFileSize,
                        request.excludeOrientation)
        );

        statesHandler.processSuccess(record, record.get().getStatus().downloadedFileFromService2, op);

        for (ServiceIncomingImage downloadedFile : record.get().getStatus().downloadedFileFromService2.get().getResultO()) {
            Content downloadedContent = ContentUtils.asContent(downloadedFile.getIncomingFile());
            statesHandler.processSuccess(record, record.get().getStatus().downloadedFileInfo,
                    stages.contentInfoF(
                            downloadedContent,
                            downloadedFile.getIncomingFile().getRawFile(),
                            Option.of(record.get().getRequest().chemodanFile.getPath())));

            for (ContentInfo info : record.get().getStatus().downloadedFileInfo.get().getResultO()) {
                downloadedContent = ContentUtils.withType(info.getContentType(), downloadedContent);
            }

            postProcessFile(record, downloadedContent,
                    record.get().getRequest().chemodanFile.getUidOrSpecial(),
                    record.get().getStatus().postProcess,
                    downloadedFile.getServiceImageInfo());
        }
    }
}
