package ru.yandex.chemodan.uploader.registry.processors;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord.UploadToService;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.services.ServiceApis;
import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentInfo;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.commune.uploader.util.http.IncomingFile;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class UploadToServiceProcessor extends RequestProcessor<UploadToService> {

    private final ServiceApis serviceApis;

    public UploadToServiceProcessor(RequestStatesHandler statesListener, Stages stages, ServiceApis serviceApis) {
        super(UploadToService.class, statesListener, stages);
        this.serviceApis = serviceApis;
    }

    @Override
    protected void processTs(Record<UploadToService> record) {
        for (final IncomingFile incomingFile : record.get().getStatus().userFile.get().getResultO()) {
            // XXX should require webdav to send filename for mime detection
            statesHandler.processSuccess(record, record.get().getStatus().payloadInfo,
                    stages.contentInfoF(incomingFile, Option.empty()));

            for (ContentInfo payloadInfo : record.get().getStatus().payloadInfo.get().getResultO()) {
                final Content content = ContentUtils.withType(
                        payloadInfo.getContentType(),
                        ContentUtils.multipartOrRaw(record.get().getStatus().userFile.get().getResultO().get()));

                statesHandler.processSuccess(record, record.get().getStatus().publishResult,
                        () -> serviceApis.publish(record.get().getRequest().chemodanFile,
                                content,
                                record.get().getRequest().targetService));
            }
        }
    }
}
