package ru.yandex.chemodan.uploader.registry.record;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.DefaultToString;

/**
 * @author vavinov
 */
public class Digests extends DefaultToString {
    @JsonProperty
    public final String md5;
    @JsonProperty
    public final String sha256;
    @JsonProperty
    public final File2 webDavDigestFile;

    @JsonCreator
    public Digests(
            @JsonProperty("md5") String md5,
            @JsonProperty("sha256") String sha256,
            @JsonProperty("webDavDigestFile") File2 webDavDigestFile)
    {
        this.md5 = md5;
        this.sha256 = sha256;
        this.webDavDigestFile = webDavDigestFile;
    }
}
