package ru.yandex.chemodan.uploader.registry.record;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.RequestLease;
import ru.yandex.commune.uploader.registry.RequestMeta;
import ru.yandex.commune.uploader.registry.RequestRecord;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.commune.uploader.util.http.IncomingFile;

/**
 * MpfsRequest + MpfsRequestStatus
 *
 * The main purpose of these classes is to provide default MpfsRequestStatus instance.
 * Technically it could be done directly in MpfsRequest;
 * moved here only for better encapsulation and separation of concerns.
 *
 * @author vavinov
 */
public abstract class MpfsRequestRecord extends RequestRecord {

    public MpfsRequestRecord(RequestMeta meta, RequestRevision revision, Option<RequestLease> lease,
            MpfsRequest request, MpfsRequestStatus status)
    {
        super(meta, revision, lease, request, status);
    }

    public MpfsRequest getRequest() {
        return (MpfsRequest) super.getRequest();
    }

    public MpfsRequestStatus getStatus() {
        return (MpfsRequestStatus) super.getStatus();
    }

    public static class UploadToDefault extends MpfsRequestRecord {
        @JsonCreator
        public UploadToDefault(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.UploadToDefault request,
                @JsonProperty("status") MpfsRequestStatus.UploadToDefault status)
        {
            super(meta, revision, lease, request, status);
        }

        public UploadToDefault(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.UploadToDefault request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.UploadToDefault());
        }

        @Override
        public UploadToDefault withIncrementedRevision(HostInstant now) {
            return new UploadToDefault(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.UploadToDefault getRequest() {
            return (MpfsRequest.UploadToDefault) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.UploadToDefault getStatus() {
            return (MpfsRequestStatus.UploadToDefault) super.getStatus();
        }

        @Override
        protected String getXmlRootElement() {
            return "upload-info";
        }
    }

    public static class UploadToService extends MpfsRequestRecord {
        @JsonCreator
        public UploadToService(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.UploadToService request,
                @JsonProperty("status") MpfsRequestStatus.UploadToService status)
        {
            super(meta, revision, lease, request, status);
        }

        public UploadToService(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.UploadToService request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.UploadToService());
        }

        @Override
        public UploadToService withIncrementedRevision(HostInstant now) {
            return new UploadToService(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.UploadToService getRequest() {
            return (MpfsRequest.UploadToService) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.UploadToService getStatus() {
            return (MpfsRequestStatus.UploadToService) super.getStatus();
        }

        @Override
        protected String getXmlRootElement() {
            return "upload-to-service-info";
        }
    }

    public static class PatchAtDefault extends MpfsRequestRecord {
        @JsonCreator
        public PatchAtDefault(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.PatchAtDefault request,
                @JsonProperty("status") MpfsRequestStatus.PatchAtDefault status)
        {
            super(meta, revision, lease, request, status);
        }

        public PatchAtDefault(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.PatchAtDefault request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.PatchAtDefault());
        }

        @Override
        public PatchAtDefault withIncrementedRevision(HostInstant now) {
            return new PatchAtDefault(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.PatchAtDefault getRequest() {
            return (MpfsRequest.PatchAtDefault) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.PatchAtDefault getStatus() {
            return (MpfsRequestStatus.PatchAtDefault) super.getStatus();
        }

        @Override
        protected String getXmlRootElement() {
            return "patch-info";
        }
    }

    public static class ListArchive extends MpfsRequestRecord {
        @JsonCreator
        public ListArchive(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.ListArchive request,
                @JsonProperty("status") MpfsRequestStatus.ListArchive status)
        {
            super(meta, revision, lease, request, status);
        }

        public ListArchive(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.ListArchive request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.ListArchive());
        }

        @Override
        public ListArchive withIncrementedRevision(HostInstant now) {
            return new ListArchive(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.ListArchive getRequest() {
            return (MpfsRequest.ListArchive) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.ListArchive getStatus() {
            return (MpfsRequestStatus.ListArchive) super.getStatus();
        }
    }

    public static class ExtractArchive extends MpfsRequestRecord {
        @JsonCreator
        public ExtractArchive(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.ExtractArchive request,
                @JsonProperty("status") MpfsRequestStatus.ExtractArchive status)
        {
            super(meta, revision, lease, request, status);
        }

        public ExtractArchive(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.ExtractArchive request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.ExtractArchive());
        }

        @Override
        public ExtractArchive withIncrementedRevision(HostInstant now) {
            return new ExtractArchive(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.ExtractArchive getRequest() {
            return (MpfsRequest.ExtractArchive) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.ExtractArchive getStatus() {
            return (MpfsRequestStatus.ExtractArchive) super.getStatus();
        }
    }

    public static class ExtractFileFromArchive extends MpfsRequestRecord {
        @JsonCreator
        public ExtractFileFromArchive(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.ExtractFileFromArchive request,
                @JsonProperty("status") MpfsRequestStatus.ExtractFileFromArchive status)
        {
            super(meta, revision, lease, request, status);
        }

        public ExtractFileFromArchive(RequestMeta meta, HostInstant assignment,
                              RequestRevision revision, MpfsRequest.ExtractFileFromArchive request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.ExtractFileFromArchive());
        }

        @Override
        public ExtractFileFromArchive withIncrementedRevision(HostInstant now) {
            return new ExtractFileFromArchive(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.ExtractFileFromArchive getRequest() {
            return (MpfsRequest.ExtractFileFromArchive) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.ExtractFileFromArchive getStatus() {
            return (MpfsRequestStatus.ExtractFileFromArchive) super.getStatus();
        }
    }

    public static class ConvertToMsOoxmlFormat extends MpfsRequestRecord {
        @JsonCreator
        public ConvertToMsOoxmlFormat(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.ConvertToMsOoxmlFormat request,
                @JsonProperty("status") MpfsRequestStatus.ConvertToMsOoxmlFormat status)
        {
            super(meta, revision, lease, request, status);
        }

        public ConvertToMsOoxmlFormat(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.ConvertToMsOoxmlFormat request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.ConvertToMsOoxmlFormat());
        }

        @Override
        public ConvertToMsOoxmlFormat withIncrementedRevision(HostInstant now) {
            return new ConvertToMsOoxmlFormat(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.ConvertToMsOoxmlFormat getRequest() {
            return (MpfsRequest.ConvertToMsOoxmlFormat) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.ConvertToMsOoxmlFormat getStatus() {
            return (MpfsRequestStatus.ConvertToMsOoxmlFormat) super.getStatus();
        }
    }

    public static class GeneratePreview extends MpfsRequestRecord {
        @JsonCreator
        public GeneratePreview(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.GeneratePreview request,
                @JsonProperty("status") MpfsRequestStatus.GeneratePreview status)
        {
            super(meta, revision, lease, request, status);
        }

        public GeneratePreview(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.GeneratePreview request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.GeneratePreview());
        }

        @Override
        public GeneratePreview withIncrementedRevision(HostInstant now) {
            return new GeneratePreview(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.GeneratePreview getRequest() {
            return (MpfsRequest.GeneratePreview) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.GeneratePreview getStatus() {
            return (MpfsRequestStatus.GeneratePreview) super.getStatus();
        }
    }

    public static class RegeneratePreview extends MpfsRequestRecord {
        @JsonCreator
        public RegeneratePreview(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.RegeneratePreview request,
                @JsonProperty("status") MpfsRequestStatus.RegeneratePreview status)
        {
            super(meta, revision, lease, request, status);
        }

        public RegeneratePreview(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.RegeneratePreview request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.RegeneratePreview());
        }

        @Override
        public RegeneratePreview withIncrementedRevision(HostInstant now) {
            return new RegeneratePreview(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.RegeneratePreview getRequest() {
            return (MpfsRequest.RegeneratePreview) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.RegeneratePreview getStatus() {
            return (MpfsRequestStatus.RegeneratePreview) super.getStatus();
        }
    }

    public static class ZipFolder extends MpfsRequestRecord {
        public ZipFolder(RequestMeta meta, RequestRevision revision, Option<RequestLease> lease,
                MpfsRequest.ZipFolder request, MpfsRequestStatus.ZipFolder status)
        {
            super(meta, revision, lease, request, status);
        }

        public ZipFolder(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.ZipFolder request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.ZipFolder());
        }

        @Override
        public RequestRecord withIncrementedRevision(HostInstant now) {
            return new ZipFolder(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.ZipFolder getRequest() {
            return (MpfsRequest.ZipFolder) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.ZipFolder getStatus() {
            return (MpfsRequestStatus.ZipFolder) super.getStatus();
        }

        @Override
        public boolean storeInCacheOnly() {
            return true;
        }
    }

    public static class PublishToService extends MpfsRequestRecord {
        @JsonCreator
        public PublishToService(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.PublishToService request,
                @JsonProperty("status") MpfsRequestStatus.PublishToService status)
        {
            super(meta, revision, lease, request, status);
        }

        public PublishToService(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.PublishToService request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.PublishToService());
        }

        @Override
        public PublishToService withIncrementedRevision(HostInstant now) {
            return new PublishToService(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.PublishToService getRequest() {
            return (MpfsRequest.PublishToService) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.PublishToService getStatus() {
            return (MpfsRequestStatus.PublishToService) super.getStatus();
        }

        @Override
        protected String getXmlRootElement() {
            return "publish-info";
        }

    }

    public static class UploadFromService extends MpfsRequestRecord {
        @JsonCreator
        public UploadFromService(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.UploadFromService request,
                @JsonProperty("status") MpfsRequestStatus.UploadFromService status)
        {
            super(meta, revision, lease, request, status);
        }

        public UploadFromService(RequestMeta meta,  HostInstant assignment,
                RequestRevision revision, MpfsRequest.UploadFromService request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.UploadFromService());
        }

        @Override
        public UploadFromService withIncrementedRevision(HostInstant now) {
            return new UploadFromService(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.UploadFromService getRequest() {
            return (MpfsRequest.UploadFromService) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.UploadFromService getStatus() {
            return (MpfsRequestStatus.UploadFromService) super.getStatus();
        }
    }

    public static class ExportPhotos extends MpfsRequestRecord {
        @JsonCreator
        public ExportPhotos(
                @JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.ExportPhotos request,
                @JsonProperty("status") MpfsRequestStatus.ExportPhotos status)
        {
            super(meta, revision, lease, request, status);
        }

        public ExportPhotos(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.ExportPhotos request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.ExportPhotos(request.photoPreviewMulcaIds.size()));
        }

        @Override
        public ExportPhotos withIncrementedRevision(HostInstant now) {
            return new ExportPhotos(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.ExportPhotos getRequest() {
            return (MpfsRequest.ExportPhotos) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.ExportPhotos getStatus() {
            return (MpfsRequestStatus.ExportPhotos) super.getStatus();
        }
    }

    public static class MarkMulcaIdsForRemove extends MpfsRequestRecord {

        @JsonCreator
        public MarkMulcaIdsForRemove(@JsonProperty("meta") RequestMeta meta,
                @JsonProperty("revision") RequestRevision revision,
                @JsonProperty("lease") Option<RequestLease> lease,
                @JsonProperty("request") MpfsRequest.MarkMulcaIdsForRemove request,
                @JsonProperty("status") MpfsRequestStatus.MarkMulcaIdsForRemove status)
        {
            super(meta, revision, lease, request, status);
        }

        public MarkMulcaIdsForRemove(RequestMeta meta, HostInstant assignment,
                RequestRevision revision, MpfsRequest.MarkMulcaIdsForRemove request)
        {
            this(meta, revision, Option.of(RequestLease.cons(assignment)), request,
                    new MpfsRequestStatus.MarkMulcaIdsForRemove(request.mulcaIds.size()));
        }

        @Override
        public RequestRecord withIncrementedRevision(HostInstant now) {
            return new MarkMulcaIdsForRemove(this.meta, revision.inc(now),
                    lease.map(RequestLease.markAliveF(now)), this.getRequest(), this.getStatus());
        }

        @Override
        public MpfsRequest.MarkMulcaIdsForRemove getRequest() {
            return (MpfsRequest.MarkMulcaIdsForRemove) super.getRequest();
        }

        @Override
        public MpfsRequestStatus.MarkMulcaIdsForRemove getStatus() {
            return (MpfsRequestStatus.MarkMulcaIdsForRemove) super.getStatus();
        }
    }

    public static Function<MpfsRequestRecord, ? extends MpfsRequest> requestF() {
        return new Function<MpfsRequestRecord, MpfsRequest>() {
            public MpfsRequest apply(MpfsRequestRecord mpfsRequestRecord) {
                return mpfsRequestRecord.getRequest();
            }
        };
    }

    public static Function<MpfsRequestRecord, ? extends MpfsRequestStatus> statusF() {
        return new Function<MpfsRequestRecord, MpfsRequestStatus>() {
            public MpfsRequestStatus apply(MpfsRequestRecord mpfsRequestRecord) {
                return mpfsRequestRecord.getStatus();
            }
        };
    }

    public static Function<MpfsRequestRecord, Option<MutableState<IncomingFile>>> recordToFileStateOF() {
        return new Function<MpfsRequestRecord, Option<MutableState<IncomingFile>>>() {
            @Override
            public Option<MutableState<IncomingFile>> apply(MpfsRequestRecord mpfsRequestRecord) {
                return mpfsRequestRecord.getStatus().waitForExternalField();
            }
        };
    }
}
