package ru.yandex.chemodan.uploader.registry.record;

import ru.yandex.bolts.function.Function2;
import ru.yandex.commune.uploader.registry.RequestMeta;
import ru.yandex.commune.uploader.registry.RequestRevision;
import ru.yandex.commune.uploader.util.HostInstant;
import ru.yandex.commune.uploader.util.Named;

/**
 * Nothing to see here, just dispatching.
 *
 * @author vavinov
 */
public class MpfsRequestRecordUtils {
    private static abstract class NamedFunction2<A1, A2, R> implements Named, Function2<A1, A2, R> {
        private final String name;

        private NamedFunction2(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return name;
        }
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.UploadToDefault> consF(
            final MpfsRequest.UploadToDefault request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.UploadToDefault>("utd") {
            public MpfsRequestRecord.UploadToDefault apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.UploadToDefault(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.UploadToService> consF(
            final MpfsRequest.UploadToService request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.UploadToService>("uts") {
            public MpfsRequestRecord.UploadToService apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.UploadToService(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.PatchAtDefault> consF(
            final MpfsRequest.PatchAtDefault request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.PatchAtDefault>("pad") {
            public MpfsRequestRecord.PatchAtDefault apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.PatchAtDefault(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.ListArchive> consF(
            final MpfsRequest.ListArchive request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.ListArchive>("lar") {
            public MpfsRequestRecord.ListArchive apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.ListArchive(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.ExtractArchive> consF(
            final MpfsRequest.ExtractArchive request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.ExtractArchive>("ear") {
            public MpfsRequestRecord.ExtractArchive apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.ExtractArchive(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.ExtractFileFromArchive> consF(
            final MpfsRequest.ExtractFileFromArchive request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.ExtractFileFromArchive>("effar") {
            public MpfsRequestRecord.ExtractFileFromArchive apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.ExtractFileFromArchive(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.ConvertToMsOoxmlFormat> consF(
            final MpfsRequest.ConvertToMsOoxmlFormat request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.ConvertToMsOoxmlFormat>("ctmof") {
            public MpfsRequestRecord.ConvertToMsOoxmlFormat apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.ConvertToMsOoxmlFormat(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.GeneratePreview> consF(
            final MpfsRequest.GeneratePreview request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.GeneratePreview>("gip") {
            public MpfsRequestRecord.GeneratePreview apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.GeneratePreview(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.RegeneratePreview> consF(
            final MpfsRequest.RegeneratePreview request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.RegeneratePreview>("rp") {
            public MpfsRequestRecord.RegeneratePreview apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.RegeneratePreview(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.ZipFolder> consF(
            final MpfsRequest.ZipFolder request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.ZipFolder>("zff") {
            public MpfsRequestRecord.ZipFolder apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.ZipFolder(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.PublishToService> consF(
            final MpfsRequest.PublishToService request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.PublishToService>("pts") {
            public MpfsRequestRecord.PublishToService apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.PublishToService(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.UploadFromService> consF(
            final MpfsRequest.UploadFromService request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.UploadFromService>("ufs") {
            public MpfsRequestRecord.UploadFromService apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.UploadFromService(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.ExportPhotos> consF(
            final MpfsRequest.ExportPhotos request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.ExportPhotos>("ep") {
            public MpfsRequestRecord.ExportPhotos apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.ExportPhotos(meta, assign, revision, request);
            }
        };
    }

    public static Function2<RequestMeta, HostInstant, MpfsRequestRecord.MarkMulcaIdsForRemove> consF(
            final MpfsRequest.MarkMulcaIdsForRemove request, final RequestRevision revision)
    {
        return new NamedFunction2<RequestMeta, HostInstant, MpfsRequestRecord.MarkMulcaIdsForRemove>("rmid") {
            public MpfsRequestRecord.MarkMulcaIdsForRemove apply(RequestMeta meta, HostInstant assign) {
                return new MpfsRequestRecord.MarkMulcaIdsForRemove(meta, assign, revision, request);
            }
        };
    }
}
