package ru.yandex.chemodan.uploader.registry.record;

import ru.yandex.chemodan.uploader.log.Events;
import ru.yandex.chemodan.uploader.log.StageInfo;
import ru.yandex.commune.uploader.log.Event;
import ru.yandex.commune.uploader.registry.RecordWrapper;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * Type specialization and logging.
 * @author alexm
 */
public class Record<R extends MpfsRequestRecord> extends RecordWrapper<R> {
    private static final Logger logger = LoggerFactory.getLogger(Record.class);


    protected Record(UploadRegistry<? super R> uploadRegistry, R record) {
        super(uploadRegistry, record);
    }

    public static <R extends MpfsRequestRecord, T extends R> Record<T> cons(UploadRegistry<R> uploadRegistry,
            T record)
    {
        return new Record<T>(uploadRegistry, record);
    }

    @Override
    protected void logRecordUpdate(String name, State<?> value) {
        if (value instanceof Event.Provider) {
            try {
                Events.log(new StageInfo(record.getRequest().getClass().getSimpleName(), name),
                        ((Event.Provider) value).getEvent());
            } catch (Exception ex) {
                logger.error("Failed to log event: " + ex, ex);
            }
        }
    }
}
