package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;
import ru.yandex.commune.uploader.util.http.ContentInfo;
import ru.yandex.commune.uploader.util.http.IncomingFile;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author alexm
 */
public class DefaultUploadStatus extends DefaultObject implements StatusFieldProvider {

    @JsonProperty
    public boolean isActive;
    @JsonProperty
    public final IncomingFile userFile;
    @JsonProperty
    public final MutableState<ContentInfo> payloadInfo;
    @JsonProperty
    public final PostProcessStatus postProcess;
    @JsonProperty
    public final int index;
    @JsonProperty
    public final ChemodanFile chemodanFile;

    public DefaultUploadStatus(int index, IncomingFile userFile, ChemodanFile chemodanFile) {
        this(false, userFile, State.initial(), new PostProcessStatus(), index, chemodanFile);
    }

    @JsonCreator
    public DefaultUploadStatus(
            @JsonProperty("isActive") boolean isActive,
            @JsonProperty("userFile") IncomingFile userFile,
            @JsonProperty("payloadInfo") State<ContentInfo> payloadInfo,
            @JsonProperty("postProcess") PostProcessStatus postProcess,
            @JsonProperty("index") int index,
            @JsonProperty("chemodanFile") ChemodanFile chemodanFile)

    {
        this.isActive = isActive;
        this.userFile = userFile;
        this.payloadInfo = MutableState.cons(payloadInfo);
        this.postProcess = postProcess;
        this.index = index;
        this.chemodanFile = chemodanFile;
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }

    @Override
    public String getPrefix() {
        return "du[" + index + "].";
    }

}
