package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.misc.io.file.File2;

/**
 * @author metal
 */
public class DigestCalculationStatus implements DescribableResult {
    @JsonProperty
    private final Option<File2> digestFile;
    @JsonProperty
    private final Option<Long> size;

    @JsonCreator
    public DigestCalculationStatus(
            @JsonProperty("digestFile") Option<File2> digestFile,
            @JsonProperty("size") Option<Long> size)
    {
        this.digestFile = digestFile;
        this.size = size;
    }

    public DigestCalculationStatus(File2 digestFile) {
        this(Option.of(digestFile), Option.of(digestFile.length()));
    }

    @Override
    public MapF<String, String> describe() {
        return Cf.map("digestFile", digestFile.map(File2::getAbsolutePath).getOrElse(""))
                .plus1("size", size.map(Cf.Long.toStringF()).getOrElse(""));
    }

    public Option<File2> getDigestFile() {
        return digestFile;
    }

    public Option<Long> getSize() {
        return size;
    }
}
