package ru.yandex.chemodan.uploader.registry.record.status;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.inside.mulca.MulcaId;

/**
 * @author akirakozov
 */
public class DownloadedInMemoryMulcaFile implements DescribableResult {
    private final byte[] content;
    private final MulcaId mulcaId;

    public DownloadedInMemoryMulcaFile(byte[] content, MulcaId mulcaId) {
        this.content = content;
        this.mulcaId = mulcaId;
    }

    public byte[] getContent() {
        return content;
    }

    public MulcaId getMulcaId() {
        return mulcaId;
    }

    @Override
    public MapF<String, String> describe() {
        return Cf.map("mulca_id", mulcaId.toSerializedString())
                .plus1("content_length", Long.toString(content.length));
    }

}
