package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.social.response.SocialUploadInfoResponse.SocialUploadInfo;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;

/**
 * @author akirakozov
 */
@JsonAutoDetect(getterVisibility = Visibility.NONE)
public class ExportPhotoStatus implements StatusFieldProvider {
    @JsonProperty
    public final int index;

    @JsonProperty
    public final MutableState<UploadedMulcaFile> previewFile;
    @JsonProperty
    public final MutableState<SocialUploadInfo> uploadInfo;
    @JsonProperty
    public final MutableState<String> uploadToSocialNet;
    @JsonProperty
    public final MutableState<Boolean> commitUploadMeta;

    @JsonCreator
    public ExportPhotoStatus(
            @JsonProperty("index") int index,
            @JsonProperty("previewFile") State<UploadedMulcaFile> previewFile,
            @JsonProperty("uploadInfo") State<SocialUploadInfo> uploadInfo,
            @JsonProperty("uploadToSocialNet") State<String> uploadToSocialNet,
            @JsonProperty("commitUploadMeta") State<Boolean> commitUploadMeta)
    {
        this.index = index;
        this.previewFile = MutableState.cons(previewFile);
        this.uploadInfo = MutableState.cons(uploadInfo);
        this.uploadToSocialNet = MutableState.cons(uploadToSocialNet);
        this.commitUploadMeta = MutableState.cons(commitUploadMeta);
    }

    public ExportPhotoStatus(int index) {
        this(index, State.initial(), State.initial(), State.initial(), State.initial());
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }

    @Override
    public String getPrefix() {
        return "p[" + index + "].";
    }
}
