package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author akirakozov
 */
public class FileToZipInfo {
    @JsonProperty
    public final String hid;
    @JsonProperty
    public final MulcaId mulcaId;
    @JsonProperty
    public final DataSize size;
    @JsonProperty
    public final String mediaType;
    @JsonProperty
    public final String mimeType;

    @JsonCreator
    public FileToZipInfo(
            @JsonProperty("hid") String hid,
            @JsonProperty("mulcaId") MulcaId mulcaId,
            @JsonProperty("size") DataSize size,
            @JsonProperty("mediaType") String mediaType,
            @JsonProperty("mimeType") String mimeType)
    {
        this.hid = hid;
        this.mulcaId = mulcaId;
        this.size = size;
        this.mediaType = mediaType;
        this.mimeType = mimeType;
    }

}
