package ru.yandex.chemodan.uploader.registry.record.status;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.preview.PreviewInfo;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.commune.image.RotateAngle;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;

/**
 * @author akirakozov
 */
public class GenerateImageOnePreviewResult {
    @JsonProperty
    private final File2 previewFile;
    @JsonProperty
    private final ImageFormat previewFormat;
    @JsonProperty
    private final Option<Dimension> origSize;
    @JsonProperty
    private final Dimension previewSize;
    @JsonProperty
    private final Option<RotateAngle> rotateAngle;


    public GenerateImageOnePreviewResult(File2 previewFile, PreviewInfo info) {
        this(previewFile, info.getPreviewFormat(), info.getOrigSizeO(), info.getPreviewSize(), info.getRotateAngel());
    }

    @JsonCreator
    public GenerateImageOnePreviewResult(
            @JsonProperty("previewFile") File2 previewFile,
            @JsonProperty("previewFormat") ImageFormat previewFormat,
            @JsonProperty("origSize") Option<Dimension> origSize,
            @JsonProperty("previewSize") Dimension previewSize,
            @Nullable @JsonProperty("rotateAngel") Option<RotateAngle> rotateAngel) // remove @Nullable after migration
    {
        this.previewFile = previewFile;
        this.previewFormat = previewFormat;
        this.origSize = origSize;
        this.previewSize = previewSize;
        this.rotateAngle = rotateAngel != null ? rotateAngel : Option.empty();
    }

    public File2 getPreviewFile() {
        return previewFile;
    }

    public ImageFormat getPreviewFormat() {
        return previewFormat;
    }

    public Option<Dimension> getOrigSize() {
        return origSize;
    }

    public Dimension getPreviewSize() {
        return previewSize;
    }


    public String toString() {
        return String.format("file:%s;format:%s;origSize:%s;previewSizes:%s",
                previewFile, previewFormat, origSize, previewSize);
    }

    public Option<RotateAngle> getRotateAngle() {
        return rotateAngle;
    }
}
