package ru.yandex.chemodan.uploader.registry.record.status;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.preview.PreviewImageSize;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;

/**
 * XXX: remove after migration
 * @author akirakozov
 */
public class GenerateImagePreviewResult implements DescribableResult {
    @JsonProperty
    private final File2 workDir;
    @JsonProperty
    private final ImageFormat previewFormat;
    @JsonProperty
    private final Option<Dimension> origSize;
    @JsonProperty
    private final Map<PreviewImageSize, Dimension> previewSizes;

    public GenerateImagePreviewResult(
            @JsonProperty("workDir") File2 workDir,
            @JsonProperty("previewFormat") ImageFormat previewFormat,
            @JsonProperty("origSize") @Nullable Option<Dimension> origSize,
            @JsonProperty("previewSizes") @Nullable Map<PreviewImageSize, Dimension> previewSizes)
    {
        this.workDir = workDir;
        this.previewFormat = previewFormat;
        this.origSize = origSize == null ? Option.empty() : origSize;
        this.previewSizes = previewSizes == null ? Cf.<PreviewImageSize, Dimension>map() : previewSizes;
    }

    public File2 getWorkDir() {
        return workDir;
    }

    public ImageFormat getPreviewFormat() {
        return previewFormat;
    }

    public Option<Dimension> getOrigSize() {
        return origSize;
    }

    public Map<PreviewImageSize, Dimension> getPreviewSizes() {
        return previewSizes;
    }


    public String toString() {
        return String.format("workDir:%s;format:%s;origSize:%s;previewSizes:%s",
                workDir, previewFormat, origSize, previewSizes);
    }

    @Override
    public MapF<String, String> describe() {
        return Cf.map("format", previewFormat.name().toLowerCase());
    }
}
