package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.uploader.registry.CallbackResponseOption;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;

/**
 * @author nshmakov
 */
public class MarkMulcaIdForRemoveStatus implements StatusFieldProvider {

    @JsonProperty
    public final int index;
    @JsonProperty
    public final MutableState<CallbackResponseOption> markForRemove;

    @JsonCreator
    public MarkMulcaIdForRemoveStatus(
            @JsonProperty("index") int index,
            @JsonProperty("markForRemove") State<CallbackResponseOption> markForRemove)
    {
        this.index = index;
        this.markForRemove = MutableState.cons(markForRemove);
    }

    public MarkMulcaIdForRemoveStatus(int index) {
        this(index, State.initial());
    }

    @Override
    public String getPrefix() {
        return "rmid[" + index + "].";
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }
}
