package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Instant;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.uploader.log.DescribableResult;

/**
 * @author akirakozov
 */
public class MediaInfo implements DescribableResult {

    public static final MediaInfo EMPTY = new MediaInfo(Option.empty());

    @JsonProperty
    private final Option<Instant> creationDate;

    public MediaInfo(
            @JsonProperty("creationDate") Option<Instant> creationDate)
    {
        this.creationDate = creationDate;
    }

    public Option<Instant> getCreationDate() {
        return creationDate;
    }

    @Override
    public MapF<String, String> describe() {
        String creationDate = this.creationDate.isPresent() ?
                ISODateTimeFormat.dateTimeNoMillis().print(this.creationDate.get()) : "none";

        return Cf.map("creation-date", creationDate);
    }
}
