package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.uploader.registry.RequestStatusUtils;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;

/**
 * @author nshmakov
 */
public class MultipleMarkMulcaIdForRemoveStatus implements StatusFieldProvider {

    @JsonProperty
    public final ListF<MarkMulcaIdForRemoveStatus> queue;

    @JsonCreator
    public MultipleMarkMulcaIdForRemoveStatus(@JsonProperty("queue") ListF<MarkMulcaIdForRemoveStatus> queue) {
        this.queue = queue;
    }

    public MultipleMarkMulcaIdForRemoveStatus(int numberOfFiles) {
        this(Cf.range(0, numberOfFiles).map(new Function<Integer, MarkMulcaIdForRemoveStatus>() {
            public MarkMulcaIdForRemoveStatus apply(Integer index) {
                return new MarkMulcaIdForRemoveStatus(index);
            }
        }));
    }

    @Override
    public String getPrefix() {
        return "mrmid.";
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return queue.flatMap(new Function<MarkMulcaIdForRemoveStatus, ListF<StatusFieldInfo>>() {
            public ListF<StatusFieldInfo> apply(MarkMulcaIdForRemoveStatus a) {
                return RequestStatusUtils.statusFields(a);
            }
        });
    }
}
