package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2V;
import ru.yandex.chemodan.uploader.registry.record.Xmlizer2;
import ru.yandex.chemodan.uploader.social.response.SocialUploadInfoResponse.SocialUploadInfo;
import ru.yandex.commune.uploader.registry.RequestStatusUtils;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author akirakozov
 */
public class MultiplePhotoExport implements StatusFieldProvider {

    @JsonProperty
    public ListF<ExportPhotoStatus> queue = Cf.arrayList();

    public MultiplePhotoExport(int numOfPhotos) {
        this(Cf.range(0, numOfPhotos)
                .map(new Function<Integer, ExportPhotoStatus>() {
                    public ExportPhotoStatus apply(Integer a) {
                        return new ExportPhotoStatus(a);
                    }
                }));
    }

    @JsonCreator
    public MultiplePhotoExport(@JsonProperty("queue") ListF<ExportPhotoStatus> queue) {
        this.queue = queue;
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return queue.flatMap(new Function<ExportPhotoStatus, ListF<StatusFieldInfo>>() {
            public ListF<StatusFieldInfo> apply(ExportPhotoStatus a) {
                return RequestStatusUtils.statusFields(a);
            }
        });
    }

    @Override
    public String getPrefix() {
        return "mep.";
    }

    public void xmlize(XmlWriter xw) {
        for (ExportPhotoStatus status : queue) {
            // serialize these stage to return invalid_token error in status
            status.uploadInfo.xmlize(xw, "export-photo-url-" + status.index,
                    new Function2V<XmlWriter, SocialUploadInfo>() {
                        public void apply(XmlWriter a, SocialUploadInfo b) {
                            // nop
                        }
                    });

            // serialize these stage to return invalid_token error in status
            status.uploadToSocialNet.xmlize(xw, "export-photo-upload-" + status.index,
                    new Function2V<XmlWriter, String>() {
                        public void apply(XmlWriter a, String b) {
                            // nop
                        }
                    });

            status.commitUploadMeta.xmlize(
                    xw, "export-photo-" + status.index,
                    Xmlizer2.exportPhotoF("success-upload", status.index));
        }
    }

}
