package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.uploader.registry.RequestStatusUtils;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class MultipleStidAndDownload implements StatusFieldProvider {

    @JsonProperty
    public ListF<StidAndDownloadStatus> queue = Cf.arrayList();

    public MultipleStidAndDownload(int filesCount) {
        this(Cf.range(0, filesCount).map(StidAndDownloadStatus::new));
    }

    @JsonCreator
    public MultipleStidAndDownload(@JsonProperty("queue") ListF<StidAndDownloadStatus> queue) {
        this.queue = queue;
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return queue.flatMap(a -> RequestStatusUtils.statusFields(a));
    }

    @Override
    public String getPrefix() {
        return "msd.";
    }

}
