package ru.yandex.chemodan.uploader.registry.record.status;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.uploader.registry.RequestStatusUtils;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;

/**
 * @author ssytnik
 */
public class MultipleStream implements StatusFieldProvider {

    public final ListF<StreamStatus> queue = Cf.arrayList();

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return queue.flatMap(RequestStatusUtils::statusFields);
    }

    @Override
    public String getPrefix() {
        return "ms.";
    }

    public void fill(ListF<ZipResourceInfo> resources) {
        for (int i = 0; i < resources.length(); i++) {
            ZipResourceInfo zipResourceInfo = resources.get(i);
            queue.add(new StreamStatus(i, zipResourceInfo.getNormalizedPath(), zipResourceInfo.fileInfo));
        }
    }

}
