package ru.yandex.chemodan.uploader.registry.record.status;

import java.io.File;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.uploader.ChemodanFile;
import ru.yandex.chemodan.uploader.ExtractedFile;
import ru.yandex.chemodan.uploader.UidOrSpecial;
import ru.yandex.chemodan.uploader.registry.record.Xmlizer2;
import ru.yandex.commune.uploader.registry.RequestStatusUtils;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;
import ru.yandex.commune.uploader.util.http.IncomingFile;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author alexm
 */
@JsonAutoDetect(getterVisibility = Visibility.NONE)
public class MultipleUpload implements StatusFieldProvider {

    @JsonProperty
    public ListF<DefaultUploadStatus> queue = Cf.arrayList();

    public MultipleUpload() {

    }

    @JsonCreator
    public MultipleUpload(@JsonProperty("queue") ListF<DefaultUploadStatus> queue) {
        this.queue = queue;
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return queue.flatMap(new Function<DefaultUploadStatus, ListF<StatusFieldInfo>>() {
            public ListF<StatusFieldInfo> apply(DefaultUploadStatus dus) {
                return RequestStatusUtils.statusFields(dus);
            }
        });
    }

    @Override
    public String getPrefix() {
        return "mu.";
    }

    public void fill(UidOrSpecial uidOrSpecial, String archivePath, ListF<ExtractedFile> extractedFiles) {
        String archiveName = new File(archivePath).getName();
        for (int i = 0; i < extractedFiles.length(); ++i) {
            ExtractedFile extractedFile = extractedFiles.get(i);
            File2 localFile = extractedFile.getLocalFile();
            IncomingFile userFile = new IncomingFile(Option.empty(),
                    Option.of(DataSize.fromBytes(localFile.length())), localFile);
            DefaultUploadStatus uploadStatus = new DefaultUploadStatus(i, userFile,
                    new ChemodanFile(uidOrSpecial, "",
                            StringUtils.defaultIfEmpty(extractedFile.getEntry().getPath(), archiveName)));
            queue.add(uploadStatus);
        }
    }

    public void xmlize(XmlWriter xw) {
        xw.startElement("multiple-upload");
        for (DefaultUploadStatus status : queue) {
            xw.startElement("upload");
            xw.addAttribute("archive-path", status.chemodanFile.getPath());
            if (status.isActive) {
                xw.startElement("local-file");
                Xmlizer2.xmlizeIncomingFileF().apply(xw, status.userFile);
                xw.endElement();
                status.payloadInfo.xmlize(xw, "incoming-file", Xmlizer2.xmlizeContentInfoF());
                Xmlizer2.xmlizePostProcessStatus(xw, status.postProcess);
            }
            xw.endElement();
        }
        xw.endElement();
    }
}
