package ru.yandex.chemodan.uploader.registry.record.status;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.uploader.log.DescribableResult;

/**
 * @author ssytnik
 */
public class ParsedTreeResult implements DescribableResult {
    private final long totalSize;
    private ListF<ZipResourceInfo> tree;

    public ParsedTreeResult(long totalSize, ListF<ZipResourceInfo> tree) {
        this.totalSize = totalSize;
        this.tree = tree;
    }

    public long getFoldersCount() {
        return tree.length() - getFilesCount();
    }

    public long getFilesCount() {
        return tree.count(ZipResourceInfo.isFileF());
    }

    public ListF<ZipResourceInfo> getTree() {
        return tree;
    }

    @Override
    public MapF<String, String> describe() {
        return Cf.map("total-size", String.valueOf(totalSize))
                .plus1("files", String.valueOf(getFilesCount()))
                .plus1("folders", String.valueOf(getFoldersCount()));
    }
}
