package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.uploader.av.AntivirusResult;
import ru.yandex.chemodan.uploader.mulca.MulcaUploadInfo;
import ru.yandex.commune.uploader.registry.CachedFieldsInfo;
import ru.yandex.commune.uploader.registry.CallbackResponseOption;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.RecordWrapper;
import ru.yandex.commune.uploader.registry.RequestDirectorUtils;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;
import ru.yandex.commune.uploader.registry.UploadRequestBaseStatus;
import ru.yandex.commune.uploader.util.MapUtils;
import ru.yandex.commune.video.format.FileInformation;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.lang.DefaultObject;

/**
 * Mutable because it's too much hassle writing with- methods (maybe later).
 *
 * @author vavinov
 */
@JsonAutoDetect(getterVisibility = Visibility.NONE, isGetterVisibility = Visibility.NONE)
public class PostProcessStatus extends DefaultObject implements StatusFieldProvider {

    private final Function0<CachedFieldsInfo> cachedFieldsInfo;

    @JsonProperty
    public final MutableState<CallbackResponseOption> commitFileInfo;
    @JsonProperty
    public final MutableState<MulcaUploadInfo> fileMulcaUploadInfo;
    @JsonProperty
    public final MutableState<DigestCalculationStatus> digestCalculationStatus;
    @JsonProperty
    public final MutableState<MulcaUploadInfo> digestMulcaUploadInfo;
    @JsonProperty
    public final MutableState<CallbackResponseOption> commitFileUpload;
    @JsonProperty
    public final PreviewDocumentStatus previewDocumentStatus;
    @JsonProperty
    public final PreviewImageStatus previewImageStatus;
    @JsonProperty
    public final PreviewVideoStatus previewVideoStatus;
    @JsonProperty
    public final MutableState<ExifInfo> exifInfo;
    @JsonProperty
    public final MutableState<MediaInfo> mediaInfo;
    @JsonProperty
    public final MutableState<FileInformation> videoInfo;
    @JsonProperty
    public final MutableState<AntivirusResult> antivirusResult2;

    public PostProcessStatus() {
        this(State.initial(), State.initial(), State.initial(), State.initial(), State.initial(),
                PreviewDocumentStatus.initial(), PreviewImageStatus.initial(), PreviewVideoStatus.initial(),
                State.initial(), State.initial(), State.initial(), State.initial());
    }

    @JsonCreator
    public PostProcessStatus(
            @JsonProperty("commitFileInfo") @Nullable State<CallbackResponseOption> commitFileInfo,
            @JsonProperty("fileMulcaUploadInfo") @Nullable State<MulcaUploadInfo> fileMulcaUploadInfo,
            @JsonProperty("digestCalculationStatus") @Nullable State<DigestCalculationStatus> digestCalculationStatus,
            @JsonProperty("digestMulcaUploadInfo") @Nullable State<MulcaUploadInfo> digestMulcaUploadInfo,
            @JsonProperty("commitFileUpload") @Nullable State<CallbackResponseOption> commitFileUpload,
            @JsonProperty("previewDocumentStatus") @Nullable PreviewDocumentStatus previewDocumentStatus,
            @JsonProperty("previewImageStatus") @Nullable PreviewImageStatus previewImageStatus,
            @JsonProperty("previewVideoStatus") @Nullable PreviewVideoStatus previewVideoStatus,
            @JsonProperty("exifInfo") @Nullable State<ExifInfo> exifInfo,
            @JsonProperty("mediaInfo") @Nullable State<MediaInfo> mediaInfo,
            @JsonProperty("videoInfo") @Nullable State<FileInformation> videoInfo,
            @JsonProperty("antivirusResult2") @Nullable State<AntivirusResult> antivirusResult2)
    {
        this.commitFileInfo = MutableState.fromNullable(commitFileInfo);
        this.fileMulcaUploadInfo = MutableState.fromNullable(fileMulcaUploadInfo);
        this.digestCalculationStatus = MutableState.fromNullable(digestCalculationStatus);
        this.digestMulcaUploadInfo = MutableState.fromNullable(digestMulcaUploadInfo);
        if (this.digestMulcaUploadInfo.get().isSuccess() && !this.digestCalculationStatus.get().isFinished()) {
            this.digestCalculationStatus.complete(
                    new DigestCalculationStatus(
                            Option.empty(),
                            this.digestMulcaUploadInfo.get().getResultO().get().getSize()));
        }
        this.commitFileUpload = MutableState.fromNullable(commitFileUpload);
        this.previewDocumentStatus = previewDocumentStatus != null ?
                previewDocumentStatus : PreviewDocumentStatus.initial();
        this.previewImageStatus = previewImageStatus != null ? previewImageStatus : PreviewImageStatus.initial();
        this.previewVideoStatus = previewVideoStatus != null ? previewVideoStatus : PreviewVideoStatus.initial();
        this.exifInfo = MutableState.fromNullable(exifInfo);
        this.mediaInfo = MutableState.fromNullable(mediaInfo);
        this.videoInfo = MutableState.fromNullable(videoInfo);
        this.antivirusResult2 = MutableState.fromNullable(antivirusResult2);
        // must be initialized after object construction
        this.cachedFieldsInfo = MapUtils.concurrentMemoize(new Function0<CachedFieldsInfo>() {
            public CachedFieldsInfo apply() {
                return new CachedFieldsInfo(PostProcessStatus.this);
            }
        });
    }

    // XXX FIXME should not be hard-coded (for now this is only needed for testing)
    @Deprecated
    public void forceComplete() {
        this.fileMulcaUploadInfo.complete(MulcaUploadInfo.fromMulcaId(MulcaId.fromSerializedString("x")));
        this.digestCalculationStatus.complete(new DigestCalculationStatus(Option.empty(), Option.of(0L)));
        this.digestMulcaUploadInfo.complete(MulcaUploadInfo.fromMulcaId(MulcaId.fromSerializedString("x")));
        this.commitFileUpload.complete(CallbackResponseOption.none());
        this.antivirusResult2.complete(AntivirusResult.UNKNOWN);
    }

    public boolean isNeedToRollbackChanges() {
        return commitFileUpload.get().isPrematureSuccess() ||
                commitFileInfo.get().isPrematureSuccess();
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }

    @Override
    public String getPrefix() {
        return "pp.";
    }

    public void skipAllIfPrematureSuccess(final RecordWrapper<?> record) {
        ListF<MutableState> states = states();
        if (states.find(MutableState.isPrematureSuccessF()).isPresent()) {
            states.filter(MutableState.isFinishedF().notF()).forEach(
                    s -> RequestDirectorUtils.skip(record, s));
        }
    }

    public boolean isFinishedWithoutFinalStages() {
        return State.summarize(states().map(MutableState.getF())) != UploadRequestBaseStatus.Result.PROCESSING;
    }

    private ListF<MutableState> states() {
        return getCachedFieldsInfo().getFieldsWithoutFinalStages().map(StatusFieldInfo.mutableStateF());
    }

    private CachedFieldsInfo getCachedFieldsInfo() {
        return cachedFieldsInfo.apply();
    }

    public ListF<MulcaId> getUploadedFilesMids() {
        ListF<MulcaId> result = Cf.arrayList();

        addMidIfSuccess(fileMulcaUploadInfo, result);
        addMidIfSuccess(digestMulcaUploadInfo, result);
        addMidIfSuccess(previewDocumentStatus.previewMulcaUploadInfo, result);
        addMidIfSuccess(previewImageStatus.previewMulcaUploadInfo, result);
        addMidIfSuccess(previewVideoStatus.previewMulcaUploadInfo, result);

        return result;
    }

    private void addMidIfSuccess(MutableState<MulcaUploadInfo> stageState, ListF<MulcaId> result) {
        Option<MulcaUploadInfo> mulcaUploadInfoO = stageState.get().getResultO();
        if (mulcaUploadInfoO.isPresent()) {
            result.add(mulcaUploadInfoO.get().getMulcaId());
        }
    }
}
