package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.mulca.MulcaUploadInfo;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;
import ru.yandex.misc.io.file.File2;

/**
 * @author akirakozov
 */
@JsonAutoDetect(getterVisibility = Visibility.NONE)
public class PreviewDocumentStatus implements StatusFieldProvider {
    @JsonProperty
    public final MutableState<File2> generatePreview;
    @JsonProperty
    public final MutableState<MulcaUploadInfo> previewMulcaUploadInfo;

    @JsonCreator
    public PreviewDocumentStatus(
        @JsonProperty("generatePreview") State<File2> generatePreview,
        @JsonProperty("previewMulcaUploadInfo") State<MulcaUploadInfo> previewMulcaUploadInfo)
    {
        this.generatePreview = MutableState.cons(generatePreview);
        this.previewMulcaUploadInfo = MutableState.cons(previewMulcaUploadInfo);
    }

    public PreviewDocumentStatus() {
        this(State.initial(), State.initial());
    }

    public static PreviewDocumentStatus initial() {
        return new PreviewDocumentStatus();
    }

    @Override
    public String getPrefix() {
        return "pd.";
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }

}
