package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.mulca.MulcaUploadInfo;
import ru.yandex.chemodan.uploader.registry.AvatarsMeta;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;

/**
 * @author akirakozov
 */
@JsonAutoDetect(getterVisibility = Visibility.NONE)
public class PreviewImageStatus implements StatusFieldProvider {

    @JsonProperty
    public final MutableState<GenerateImageOnePreviewResult> generateOnePreview;
    @JsonProperty
    public final MutableState<MulcaUploadInfo> previewMulcaUploadInfo;
    @JsonProperty
    public final MutableState<AvatarsMeta.Colors> colorData;

    @JsonCreator
    public PreviewImageStatus(
            @JsonProperty("generateOnePreview") State<GenerateImageOnePreviewResult> generatePreview,
            @JsonProperty("previewMulcaUploadInfo") State<MulcaUploadInfo> previewImageMulcaId,
            @JsonProperty("colorData") State<AvatarsMeta.Colors> colorData)
    {
        this.generateOnePreview = MutableState.fromNullable(generatePreview);
        this.previewMulcaUploadInfo = MutableState.fromNullable(previewImageMulcaId);
        this.colorData = MutableState.fromNullable(colorData);
    }

    public PreviewImageStatus() {
        this(State.initial(), State.initial(), State.initial());
    }

    public static PreviewImageStatus initial() {
        return new PreviewImageStatus();
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }

    @Override
    public String getPrefix() {
        return "pi.";
    }
}
