package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.uploader.mulca.MulcaUploadInfo;
import ru.yandex.chemodan.uploader.registry.AvatarsMeta;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;
import ru.yandex.misc.io.file.File2;

/**
 * @author akirakozov
 *
 */
@JsonAutoDetect(getterVisibility = Visibility.NONE)
public class PreviewVideoStatus implements StatusFieldProvider {

    public static final int PREVIEW_COUNT = 5;

    @JsonProperty
    public final MutableState<File2> generatePreview;

    @JsonProperty
    public final MutableState<MulcaUploadInfo> previewMulcaUploadInfo;

    @JsonProperty
    public final MutableState<MulcaUploadInfo> multiplePreviewMulcaUploadInfo;

    @JsonProperty
    public final MutableState<AvatarsMeta.Colors> colorData;

    @JsonCreator
    public PreviewVideoStatus(
            @JsonProperty("generatePreview") State<File2> generatePreview,
            @JsonProperty("previewMulcaUploadInfo") State<MulcaUploadInfo> previewUploadInfo,
            @JsonProperty("multiplePreviewMulcaUploadInfo") State<MulcaUploadInfo> multiplePreviewMulcaUploadInfo,
            @JsonProperty("colorData") State<AvatarsMeta.Colors> colorData)
    {
        this.generatePreview = MutableState.cons(generatePreview);
        this.previewMulcaUploadInfo = MutableState.cons(previewUploadInfo);
        this.multiplePreviewMulcaUploadInfo = MutableState.fromNullable(multiplePreviewMulcaUploadInfo);
        this.colorData = MutableState.fromNullable(colorData);
    }

    public PreviewVideoStatus() {
        this(State.initial(), State.initial(), State.initial(), State.initial());
    }

    @Override
    public String getPrefix() {
        return "pv.";
    }

    public static PreviewVideoStatus initial() {
        return new PreviewVideoStatus();
    }

    public static String getPreviewFileName() {
        return "video-preview.jpg";
    }

    public static String getMultipleMontagedPreviewFileName() {
        return "video-preview-multiple.jpg";
    }

    public static String getMultiplePreviewFileName(int index) {
        return "video-preview-" + index + ".jpg";
    }

    public static ListF<Duration> getMultiplePreviewTimes(Duration videoDuration) {
        if (videoDuration.isShorterThan(Duration.standardSeconds(2))) {
            return Cf.list();
        }
        ListF<Duration> previewTimes = Cf.arrayList(Duration.standardSeconds(1));
        Duration step = new Duration((videoDuration.getMillis() - 1000) / PreviewVideoStatus.PREVIEW_COUNT);
        for (int i = 1; i < PREVIEW_COUNT; i++) {
            previewTimes.add(Duration.standardSeconds(1).plus(step.getMillis() * i));
        }
        return previewTimes.makeReadOnly();
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }
}
