package ru.yandex.chemodan.uploader.registry.record.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */

@JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE)
public class StidAndDownloadStatus implements StatusFieldProvider {
    @JsonProperty
    public final int index;
    @JsonProperty
    public final MutableState<FileToZipInfo> fileInfo;
    @JsonProperty
    public final MutableState<UploadedMulcaFile> file;
    @JsonProperty
    private String filename;


    public StidAndDownloadStatus(
            @JsonProperty("index") int index,
            @JsonProperty("fileInfo") State<FileToZipInfo> fileInfo,
            @JsonProperty("downloadedFile") State<UploadedMulcaFile> file)
    {
        this.index = index;
        this.fileInfo = MutableState.cons(fileInfo);
        this.file = MutableState.cons(file);
        this.filename = "";
    }

    public StidAndDownloadStatus(int index) {
        this(index, State.initial(), State.initial());
    }

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }

    @Override
    public String getPrefix() {
        return "p[" + index + "].";
    }

    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}
