package ru.yandex.chemodan.uploader.registry.record.status;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.uploader.registry.MutableState;
import ru.yandex.commune.uploader.registry.State;
import ru.yandex.commune.uploader.registry.StatusFieldInfo;
import ru.yandex.commune.uploader.registry.StatusFieldProvider;

/**
* @author ssytnik
 */
@RequiredArgsConstructor
public class StreamStatus implements StatusFieldProvider {

    public final int index;
    public final String normalizedPath;
    public final Option<FileToZipInfo> fileInfo;
    public final MutableState<Boolean> streamed = MutableState.cons(State.initial());

    @Override
    public ListF<StatusFieldInfo> getStatusFields() {
        return Cf.list();
    }

    @Override
    public String getPrefix() {
        return "s[" + index + "].";
    }
}
